/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.processor.impl.css;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import ro.isdc.wro.model.group.processor.Minimize;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.SupportedResourceType;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.model.resource.processor.algorithm.JawrCssMinifier;

@Minimize
@SupportedResourceType(value=ResourceType.CSS)
public class JawrCssMinifierProcessor
implements ResourcePreProcessor,
ResourcePostProcessor {
    public void process(Resource resource, Reader reader, Writer writer) throws IOException {
        this.process(reader, writer);
    }

    public void process(Reader reader, Writer writer) throws IOException {
        try {
            String content = IOUtils.toString((Reader)reader);
            StringBuffer result = new JawrCssMinifier().minifyCSS(new StringBuffer(content));
            writer.write(result.toString());
            writer.flush();
        }
        catch (Exception e) {
            throw new IOException("Exception occured while minimizing the css");
        }
        finally {
            reader.close();
            writer.close();
        }
    }
}

