/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.processor.impl.css;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.SupportedResourceType;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedResourceType(value=ResourceType.CSS)
public class CssVariablesProcessor
implements ResourcePreProcessor,
ResourcePostProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(CssVariablesProcessor.class);
    private static final String REGEX_VARIABLES_DEFINITION = "@variables\\s*\\{(.*?)\\}";
    private static final String REGEX_VARIABLES_BODY = "([^:\\s]*)\\s*:\\s*(.+?);";
    private static final String REGEX_VARIABLE_HOLDER = "var\\s*\\((.+?)\\)";
    private static final Pattern PATTERN_VARIABLES_DEFINITION = Pattern.compile("@variables\\s*\\{(.*?)\\}", 34);
    private static final Pattern PATTERN_VARIABLES_BODY = Pattern.compile("([^:\\s]*)\\s*:\\s*(.+?);", 2);
    private static final Pattern PATTERN_VARIABLE_HOLDER = Pattern.compile("var\\s*\\((.+?)\\)", 2);

    private Map<String, String> extractVariables(String variablesBody) {
        HashMap<String, String> map = new HashMap<String, String>();
        Matcher m = PATTERN_VARIABLES_BODY.matcher(variablesBody);
        LOG.debug("parsing variables body");
        while (m.find()) {
            LOG.debug("found:" + m.group());
            String key = m.group(1);
            String value = m.group(2);
            if (map.containsKey(key)) {
                LOG.warn("A duplicate variable name found with name: " + key + " and value: " + value + ".");
            }
            map.put(key, value);
        }
        return map;
    }

    @Override
    public void process(Resource resource, Reader reader, Writer writer) throws IOException {
        this.process(reader, writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Reader reader, Writer writer) throws IOException {
        try {
            String css = IOUtils.toString((Reader)reader);
            String result = this.parseCss(css);
            writer.write(result);
        }
        finally {
            reader.close();
            writer.close();
        }
    }

    private String parseCss(String css) {
        HashMap<String, String> map = new HashMap<String, String>();
        StringBuffer sb = new StringBuffer();
        Matcher m = PATTERN_VARIABLES_DEFINITION.matcher(css);
        while (m.find()) {
            String variablesBody = m.group(1);
            map.putAll(this.extractVariables(variablesBody));
            m.appendReplacement(sb, "");
        }
        m.appendTail(sb);
        String result = this.replaceVariables(sb.toString(), map);
        return result;
    }

    private String replaceVariables(String css, Map<String, String> variables) {
        StringBuffer sb = new StringBuffer();
        Matcher m = PATTERN_VARIABLE_HOLDER.matcher(css);
        while (m.find()) {
            String oldMatch = m.group();
            String variableName = m.group(1);
            String variableValue = variables.get(variableName);
            if (variableValue != null) {
                String newReplacement = oldMatch.replace(oldMatch, variableValue);
                m.appendReplacement(sb, newReplacement.trim());
                continue;
            }
            LOG.warn("No variable with name " + variableName + " was found!");
        }
        m.appendTail(sb);
        return sb.toString();
    }
}

