/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.processor.algorithm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JawrCssMinifier {
    private static final String commentRegex = "(/\\*[^*]*\\*+([^/][^*]*\\*+)*/)";
    private static final String quotedContentRegex = "('(\\\\'|[^'])*')|(\"(\\\\\"|[^\"])*\")";
    private static final String STRING_PLACEHOLDER = "______'JAWR_STRING'______";
    private static final String rulesRegex = "([^\\{\\}]*)(\\{[^\\{\\}]*})";
    private static final String newlinesTabsRegex = "\\r|\\n|\\t|\\f";
    private static final String spacesRegex = "(\\s*\\{\\s*)|(\\s*\\}\\s*)|(\\s*\\(\\s*)|(\\s*;\\s*)|(\\s*:\\s*)|(\\s*\\))|( +)";
    private static final Pattern commentsPattern = Pattern.compile("(/\\*[^*]*\\*+([^/][^*]*\\*+)*/)", 32);
    private static final Pattern spacesPattern = Pattern.compile("(\\s*\\{\\s*)|(\\s*\\}\\s*)|(\\s*\\(\\s*)|(\\s*;\\s*)|(\\s*:\\s*)|(\\s*\\))|( +)", 32);
    private static final Pattern quotedContentPattern = Pattern.compile("('(\\\\'|[^'])*')|(\"(\\\\\"|[^\"])*\")", 32);
    private static final Pattern rulesPattern = Pattern.compile("([^\\{\\}]*)(\\{[^\\{\\}]*})", 32);
    private static final Pattern newlinesTabsPattern = Pattern.compile("\\r|\\n|\\t|\\f", 32);
    private static final Pattern stringPlaceholderPattern = Pattern.compile("______'JAWR_STRING'______", 32);
    private static final String SPACE = " ";
    private static final String BRACKET_OPEN = "{";
    private static final String BRACKET_CLOSE = "}";
    private static final String PAREN_OPEN = "(";
    private static final String PAREN_CLOSE = ")";
    private static final String COLON = ":";
    private static final String SEMICOLON = ";";

    public StringBuffer minifyCSS(StringBuffer data) {
        String compressed = commentsPattern.matcher(data.toString()).replaceAll("");
        final ArrayList strings = new ArrayList();
        Matcher stringMatcher = quotedContentPattern.matcher(compressed);
        compressed = new MatcherProcessorCallback(){

            String matchCallback(Matcher matcher) {
                String match = matcher.group();
                strings.add(match);
                return JawrCssMinifier.STRING_PLACEHOLDER;
            }
        }.processWithMatcher(stringMatcher);
        Matcher rulesmatcher = rulesPattern.matcher(compressed);
        compressed = new MatcherProcessorCallback(){

            String matchCallback(Matcher matcher) {
                String match = matcher.group(1);
                String spaced = newlinesTabsPattern.matcher(match.toString()).replaceAll(JawrCssMinifier.SPACE).trim();
                return spaced + matcher.group(2);
            }
        }.processWithMatcher(rulesmatcher);
        compressed = newlinesTabsPattern.matcher(compressed).replaceAll("");
        Matcher matcher = spacesPattern.matcher(compressed);
        compressed = new MatcherProcessorCallback(){

            String matchCallback(Matcher matcher) {
                String replacement = JawrCssMinifier.SPACE;
                String match = matcher.group();
                if (match.indexOf(JawrCssMinifier.BRACKET_OPEN) != -1) {
                    replacement = JawrCssMinifier.BRACKET_OPEN;
                } else if (match.indexOf(JawrCssMinifier.BRACKET_CLOSE) != -1) {
                    replacement = JawrCssMinifier.BRACKET_CLOSE;
                } else if (match.indexOf(JawrCssMinifier.PAREN_OPEN) != -1) {
                    replacement = JawrCssMinifier.PAREN_OPEN;
                } else if (match.indexOf(JawrCssMinifier.COLON) != -1) {
                    replacement = JawrCssMinifier.COLON;
                } else if (match.indexOf(JawrCssMinifier.SEMICOLON) != -1) {
                    replacement = JawrCssMinifier.SEMICOLON;
                } else if (match.indexOf(JawrCssMinifier.PAREN_CLOSE) != -1) {
                    replacement = JawrCssMinifier.PAREN_CLOSE;
                }
                return replacement;
            }
        }.processWithMatcher(matcher);
        Matcher restoreMatcher = stringPlaceholderPattern.matcher(compressed);
        final Iterator it = strings.iterator();
        compressed = new MatcherProcessorCallback(){

            String matchCallback(Matcher matcher) {
                String replacement = (String)it.next();
                return JawrCssMinifier.adaptReplacementToMatcher(replacement);
            }
        }.processWithMatcher(restoreMatcher);
        return new StringBuffer(compressed);
    }

    public static String adaptReplacementToMatcher(String replacement) {
        String result = replacement.replaceAll("\\\\", "\\\\\\\\");
        result = result.replaceAll("\\$", "\\\\\\$");
        return result;
    }

    public abstract class MatcherProcessorCallback {
        String processWithMatcher(Matcher matcher) {
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                matcher.appendReplacement(sb, this.matchCallback(matcher));
            }
            matcher.appendTail(sb);
            return sb.toString();
        }

        abstract String matchCallback(Matcher var1);
    }
}

