/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.locator;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.model.resource.locator.wildcard.WildcardUriLocatorSupport;

public class UrlUriLocator
extends WildcardUriLocatorSupport {
    private static final Logger LOG = LoggerFactory.getLogger(UrlUriLocator.class);

    public boolean accept(String uri) {
        return UrlUriLocator.isValid(uri);
    }

    public static boolean isValid(String uri) {
        try {
            new URL(uri);
        }
        catch (MalformedURLException e) {
            return false;
        }
        return true;
    }

    public InputStream locate(String uri) throws IOException {
        if (uri == null) {
            throw new IllegalArgumentException("uri cannot be NULL!");
        }
        LOG.debug("Reading uri: " + uri);
        try {
            if (this.getWildcardStreamLocator().hasWildcard(uri)) {
                String fullPath = FilenameUtils.getFullPath((String)uri);
                URL url = new URL(fullPath);
                return this.getWildcardStreamLocator().locateStream(uri, new File(url.getFile()));
            }
        }
        catch (IOException e) {
            LOG.warn("Couldn't localize the stream containing wildcard: " + e.getMessage() + ". Trying to locate the stream without the wildcard.");
        }
        URL url = new URL(uri);
        return url.openStream();
    }
}

