/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.locator;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.model.resource.locator.wildcard.WildcardUriLocatorSupport;
import ro.isdc.wro.util.StringUtils;

public class ClasspathUriLocator
extends WildcardUriLocatorSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ClasspathUriLocator.class);
    public static final String PREFIX = "classpath:";

    public boolean accept(String url) {
        return ClasspathUriLocator.isValid(url);
    }

    public static boolean isValid(String uri) {
        return uri.trim().startsWith(PREFIX);
    }

    public InputStream locate(String uri) throws IOException {
        if (uri == null) {
            throw new IllegalArgumentException("URI cannot be NULL!");
        }
        LOG.debug("Reading uri: " + uri);
        String location = StringUtils.cleanPath(uri.replaceFirst(PREFIX, "")).trim();
        if (this.getWildcardStreamLocator().hasWildcard(location)) {
            return this.locateWildcardUri(uri, location);
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream is = classLoader.getResourceAsStream(location);
        if (is == null) {
            throw new IOException("Couldn't get InputStream from this resource: " + uri);
        }
        return is;
    }

    private InputStream locateWildcardUri(String uri, String location) throws IOException {
        LOG.debug("wildcard detected for location: " + location);
        String fullPath = FilenameUtils.getFullPath((String)location);
        URL url = ClassLoader.getSystemResource(fullPath);
        if (url == null) {
            String message = "Couldn't get URL for the following path: " + fullPath;
            LOG.warn(message);
            throw new IOException(message);
        }
        return this.getWildcardStreamLocator().locateStream(uri, new File(url.getFile()));
    }
}

