/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.locator;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.http.DelegatingServletOutputStream;
import ro.isdc.wro.model.resource.locator.DynamicStreamLocatorStrategy;
import ro.isdc.wro.util.WroUtil;

public final class ByteArrayStreamDispatchingStrategy
implements DynamicStreamLocatorStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(ByteArrayStreamDispatchingStrategy.class);

    public synchronized InputStream getInputStream(HttpServletRequest request, HttpServletResponse response, String location) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            RequestDispatcher dispatcher = request.getRequestDispatcher(location);
            if (dispatcher == null) {
                String servletContextPath = request.getRequestURL().toString().replace(request.getServletPath(), "");
                String absolutePath = servletContextPath + location;
                URL url = new URL(absolutePath);
                return url.openStream();
            }
            ServletRequest wrappedRequest = this.getWrappedServletRequest(request, location);
            ServletResponse wrappedResponse = this.getWrappedServletResponse(response, os);
            LOG.debug("dispatching request to location: " + location);
            dispatcher.include(wrappedRequest, wrappedResponse);
            wrappedResponse.getWriter().flush();
            os.close();
        }
        catch (Exception e) {
            throw new IOException("Error while dispatching the request for location " + location);
        }
        if (os.size() == 0) {
            LOG.warn("Wrong or empty resource with location : " + location);
        }
        return new ByteArrayInputStream(os.toByteArray());
    }

    private ServletRequest getWrappedServletRequest(HttpServletRequest request, final String location) {
        HttpServletRequestWrapper wrappedRequest = new HttpServletRequestWrapper(request){

            public String getRequestURI() {
                return this.getContextPath() + location;
            }

            public String getPathInfo() {
                return WroUtil.getPathInfoFromLocation(location);
            }

            public String getServletPath() {
                return WroUtil.getServletPathFromLocation(location);
            }
        };
        return wrappedRequest;
    }

    private ServletResponse getWrappedServletResponse(HttpServletResponse response, final ByteArrayOutputStream os) {
        HttpServletResponseWrapper wrappedResponse = new HttpServletResponseWrapper(response){
            private PrintWriter pw;
            private ServletOutputStream sos;
            {
                super(x0);
                this.pw = new PrintWriter(os);
                this.sos = new DelegatingServletOutputStream(os);
            }

            public void sendError(int sc) throws IOException {
                this.onError(sc, "");
                super.sendError(sc);
            }

            public void sendError(int sc, String msg) throws IOException {
                this.onError(sc, msg);
                super.sendError(sc, msg);
            }

            private void onError(int sc, String msg) {
                LOG.debug("Error detected with code: " + sc + " and message: " + msg);
                ByteArrayOutputStream emptyStream = new ByteArrayOutputStream();
                this.pw = new PrintWriter(emptyStream);
                this.sos = new DelegatingServletOutputStream(emptyStream);
            }

            public ServletOutputStream getOutputStream() throws IOException {
                return this.sos;
            }

            public void sendRedirect(String location) throws IOException {
                try {
                    LOG.debug("redirecting to: " + location);
                    URL url = new URL(location);
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    InputStream is = connection.getInputStream();
                    IOUtils.copy((InputStream)is, (OutputStream)this.sos);
                    is.close();
                }
                catch (IOException e) {
                    LOG.warn("Invalid response for location: " + location);
                    throw e;
                }
            }

            public PrintWriter getWriter() throws IOException {
                return this.pw;
            }
        };
        return wrappedResponse;
    }
}

