/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.group.processor;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.model.group.Group;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.group.processor.Minimize;
import ro.isdc.wro.model.group.processor.PreProcessorExecutor;
import ro.isdc.wro.model.resource.DuplicateResourceDetector;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.SupportedResourceType;
import ro.isdc.wro.model.resource.factory.UriLocatorFactory;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGroupsProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractGroupsProcessor.class);
    private final Collection<ResourcePreProcessor> preProcessors = this.decorateCollection(new ArrayList());
    private final Collection<ResourcePostProcessor> postProcessors = this.decorateCollection(new ArrayList());
    private final DuplicateResourceDetector duplicateResourceDetector = new DuplicateResourceDetector();
    private final UriLocatorFactory uriLocatorFactory = new UriLocatorFactory(this.duplicateResourceDetector);
    private boolean ignoreMissingResources = true;
    private transient PreProcessorExecutor preProcessorExecutor;

    public AbstractGroupsProcessor() {
        this.configureUriLocatorFactory(this.uriLocatorFactory);
    }

    protected final PreProcessorExecutor getPreProcessorExecutor() {
        if (this.preProcessorExecutor == null) {
            this.preProcessorExecutor = new PreProcessorExecutor(this.getUriLocatorFactory(), this.getDuplicateResourceDetector()){

                @Override
                protected boolean ignoreMissingResources() {
                    return AbstractGroupsProcessor.this.isIgnoreMissingResources();
                }

                @Override
                protected Collection<ResourcePreProcessor> getPreProcessorsByType(ResourceType resourceType) {
                    return AbstractGroupsProcessor.this.getPreProcessorsByType(resourceType);
                }
            };
        }
        return this.preProcessorExecutor;
    }

    private <T> Collection<T> decorateCollection(Collection<T> c) {
        return new ArrayList<T>(c){

            @Override
            public void add(int index, T element) {
                AbstractGroupsProcessor.this.processInjectAnnotation(element);
                super.add(index, element);
            }

            @Override
            public boolean add(T element) {
                AbstractGroupsProcessor.this.processInjectAnnotation(element);
                return super.add(element);
            }

            @Override
            public boolean addAll(Collection<? extends T> c) {
                for (Object element : c) {
                    AbstractGroupsProcessor.this.processInjectAnnotation(element);
                }
                return super.addAll(c);
            }

            @Override
            public boolean addAll(int index, Collection<? extends T> c) {
                for (Object element : c) {
                    AbstractGroupsProcessor.this.processInjectAnnotation(element);
                }
                return super.addAll(index, c);
            }
        };
    }

    public final <T extends ResourcePreProcessor> T findPreProcessorByClass(Class<T> processorClass) {
        ResourcePreProcessor found = null;
        HashSet<ResourcePreProcessor> allPreProcessors = new HashSet<ResourcePreProcessor>();
        allPreProcessors.addAll(this.preProcessors);
        for (ResourcePreProcessor processor : allPreProcessors) {
            if (!processorClass.isInstance(processor)) continue;
            found = processor;
            return (T)found;
        }
        return null;
    }

    private void processInjectAnnotation(Object processor) {
        try {
            Field[] fields;
            for (Field field : fields = processor.getClass().getDeclaredFields()) {
                if (!field.isAnnotationPresent(Inject.class) || this.acceptAnnotatedField(processor, field)) continue;
                throw new WroRuntimeException("@Inject can be applied only on fields of " + UriLocatorFactory.class.getName() + " type");
            }
        }
        catch (Exception e) {
            throw new WroRuntimeException("Exception while trying to process Inject annotation", e);
        }
    }

    private boolean acceptAnnotatedField(Object object, Field field) throws IllegalAccessException {
        field.setAccessible(true);
        if (field.getType().equals(UriLocatorFactory.class)) {
            field.set(object, this.getUriLocatorFactory());
            LOG.debug("Successfully injected field: " + field.getName());
            return true;
        }
        if (field.getType().equals(PreProcessorExecutor.class)) {
            field.set(object, this.getPreProcessorExecutor());
            LOG.debug("Successfully injected field: " + field.getName());
            return true;
        }
        if (field.getType().equals(DuplicateResourceDetector.class)) {
            field.set(object, this.duplicateResourceDetector);
            LOG.debug("Successfully injected duplicateResourceDetector: " + field.getName());
            return true;
        }
        return false;
    }

    private <T> Collection<T> getProcessorsByType(ResourceType type, Collection<T> availableProcessors) {
        ArrayList<T> found = new ArrayList<T>();
        for (T processor : availableProcessors) {
            SupportedResourceType supportedType = processor.getClass().getAnnotation(SupportedResourceType.class);
            boolean isTypeSatisfied = supportedType == null || supportedType != null && type == supportedType.value();
            if (!isTypeSatisfied) continue;
            found.add(processor);
        }
        return found;
    }

    protected final List<Resource> getFilteredResources(Collection<Group> groups, ResourceType type) {
        ArrayList<Resource> allResources = new ArrayList<Resource>();
        for (Group group : groups) {
            allResources.addAll(group.getResources());
        }
        ArrayList<Resource> filteredResources = new ArrayList<Resource>();
        for (Resource resource : allResources) {
            if (type != resource.getType()) continue;
            if (filteredResources.contains(resource)) {
                LOG.warn("Duplicated resource detected: " + resource + ". This resource won't be included more than once!");
                continue;
            }
            filteredResources.add(resource);
        }
        return filteredResources;
    }

    public boolean isIgnoreMissingResources() {
        return this.ignoreMissingResources;
    }

    public void setIgnoreMissingResources(boolean ignoreMissingResources) {
        this.ignoreMissingResources = ignoreMissingResources;
    }

    public void setResourcePreProcessors(Collection<ResourcePreProcessor> processors) {
        this.preProcessors.clear();
        if (processors != null) {
            this.preProcessors.addAll(processors);
        }
    }

    public void setResourcePostProcessors(Collection<ResourcePostProcessor> processors) {
        this.postProcessors.clear();
        if (processors != null) {
            this.postProcessors.addAll(processors);
        }
    }

    public void addPreProcessor(ResourcePreProcessor processor) {
        this.preProcessors.add(processor);
    }

    public void addPostProcessor(ResourcePostProcessor processor) {
        if (processor.getClass().isAnnotationPresent(Minimize.class)) {
            LOG.warn("It is recommended to add minimize aware processors to pre processors instead of post processor, otherwise you won't be able to disable minimization on specific resources using minimize='false' attribute.");
        }
        this.postProcessors.add(processor);
    }

    protected void configureUriLocatorFactory(UriLocatorFactory factory) {
    }

    public final UriLocatorFactory getUriLocatorFactory() {
        if (this.uriLocatorFactory == null) {
            throw new WroRuntimeException("No uriLocatorFactory detected! Did you forget to call setUriLocatorFactory before adding any processors?");
        }
        return this.uriLocatorFactory;
    }

    public final Collection<ResourcePreProcessor> getPreProcessorsByType(ResourceType type) {
        return this.getProcessorsByType(type, this.preProcessors);
    }

    public final Collection<ResourcePostProcessor> getPostProcessorsByType(ResourceType type) {
        return this.getProcessorsByType(type, this.postProcessors);
    }

    public DuplicateResourceDetector getDuplicateResourceDetector() {
        return this.duplicateResourceDetector;
    }
}

