/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.factory;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.config.WroConfigurationChangeListener;
import ro.isdc.wro.model.WroModel;
import ro.isdc.wro.model.factory.WroModelFactory;
import ro.isdc.wro.model.group.Group;
import ro.isdc.wro.model.group.RecursiveGroupDefinitionException;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.util.StopWatch;
import ro.isdc.wro.util.WroUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlModelFactory
implements WroModelFactory,
WroConfigurationChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(XmlModelFactory.class);
    protected static final String XML_CONFIG_FILE = "wro.xml";
    private static final String XML_SCHEMA_FILE = "ro/isdc/wro/wro.xsd";
    private static final String TAG_GROUP = "group";
    private static final String TAG_CSS = "css";
    private static final String TAG_JS = "js";
    private static final String TAG_GROUP_REF = "group-ref";
    private static final String ATTR_GROUP_NAME = "name";
    private static final String ATTR_MINIMIZE = "minimize";
    final Map<String, Element> allGroupElements = new HashMap<String, Element>();
    final Collection<String> processingGroups = new HashSet<String>();
    private volatile WroModel model;
    private ScheduledExecutorService scheduler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized WroModel getInstance() {
        this.initScheduler();
        if (this.model == null) {
            XmlModelFactory xmlModelFactory = this;
            synchronized (xmlModelFactory) {
                if (this.model == null) {
                    StopWatch stopWatch = new StopWatch();
                    stopWatch.start("Create Model");
                    this.model = this.newModel();
                    stopWatch.stop();
                    LOG.debug(stopWatch.prettyPrint());
                }
            }
        }
        return this.model;
    }

    private void initScheduler() {
        long period;
        if (this.scheduler == null && (period = Context.get().getConfig().getModelUpdatePeriod()) > 0L) {
            this.scheduler = Executors.newSingleThreadScheduledExecutor(WroUtil.createDaemonThreadFactory());
            LOG.info("Schedule Model Update for " + period + " seconds period");
            this.scheduler.scheduleWithFixedDelay(this.getSchedulerRunnable(), 0L, period, TimeUnit.SECONDS);
        }
    }

    private Runnable getSchedulerRunnable() {
        return new Runnable(){

            public void run() {
                try {
                    XmlModelFactory.this.model = XmlModelFactory.this.newModel();
                    LOG.info("Wro Model (wro.xml) updated!");
                }
                catch (Exception e) {
                    LOG.error("Exception occured", (Throwable)e);
                }
            }
        };
    }

    private WroModel newModel() {
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            InputStream configResource = this.getConfigResourceAsStream();
            if (configResource == null) {
                throw new WroRuntimeException("Could not locate config resource (wro.xml)!");
            }
            document = factory.newDocumentBuilder().parse(configResource);
            this.validate(document);
            document.getDocumentElement().normalize();
        }
        catch (IOException e) {
            throw new WroRuntimeException("Cannot find XML to parse", e);
        }
        catch (SAXException e) {
            throw new WroRuntimeException("The wro configuration file contains errors: " + e.getMessage());
        }
        catch (ParserConfigurationException e) {
            throw new WroRuntimeException("Parsing error", e);
        }
        this.initGroupMap(document);
        WroModel model = this.createModel();
        return model;
    }

    private Schema getSchema() throws IOException, SAXException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        StreamSource schemaFile = new StreamSource(XmlModelFactory.getResourceAsStream(XML_SCHEMA_FILE));
        Schema schema = factory.newSchema(schemaFile);
        return schema;
    }

    protected InputStream getConfigResourceAsStream() throws IOException {
        return XmlModelFactory.getResourceAsStream(XML_CONFIG_FILE);
    }

    private void initGroupMap(Document document) {
        NodeList groupNodeList = document.getElementsByTagName(TAG_GROUP);
        for (int i = 0; i < groupNodeList.getLength(); ++i) {
            Element groupElement = (Element)groupNodeList.item(i);
            String name = groupElement.getAttribute(ATTR_GROUP_NAME);
            this.allGroupElements.put(name, groupElement);
        }
    }

    private synchronized WroModel createModel() {
        WroModel model = new WroModel();
        HashSet<Group> groups = new HashSet<Group>();
        for (Element element : this.allGroupElements.values()) {
            this.parseGroup(element, groups);
        }
        model.setGroups(groups);
        return model;
    }

    private Collection<Resource> parseGroup(Element element, Collection<Group> groups) {
        String name = element.getAttribute(ATTR_GROUP_NAME);
        if (this.processingGroups.contains(name)) {
            throw new RecursiveGroupDefinitionException("Infinite Recursion detected for the group: " + name + ". Recursion path: " + this.processingGroups);
        }
        this.processingGroups.add(name);
        LOG.debug("\tgroupName=" + name);
        Group parsedGroup = XmlModelFactory.getGroupByName(name, groups);
        if (parsedGroup != null) {
            this.processingGroups.remove(name);
            return parsedGroup.getResources();
        }
        Group group = new Group();
        group.setName(name);
        ArrayList<Resource> resources = new ArrayList<Resource>();
        NodeList resourceNodeList = element.getChildNodes();
        for (int i = 0; i < resourceNodeList.getLength(); ++i) {
            Node node = resourceNodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element resourceElement = (Element)node;
            this.parseResource(resourceElement, resources, groups);
        }
        group.setResources(resources);
        this.processingGroups.remove(name);
        groups.add(group);
        return resources;
    }

    private static Group getGroupByName(String name, Collection<Group> groups) {
        for (Group group : groups) {
            if (!name.equals(group.getName())) continue;
            return group;
        }
        return null;
    }

    private void parseResource(Element resourceElement, Collection<Resource> resources, Collection<Group> groups) {
        ResourceType type = null;
        String tagName = resourceElement.getTagName();
        String uri = resourceElement.getTextContent();
        if (TAG_JS.equals(tagName)) {
            type = ResourceType.JS;
        } else if (TAG_CSS.equals(tagName)) {
            type = ResourceType.CSS;
        } else if (TAG_GROUP_REF.equals(tagName)) {
            Element groupElement = this.allGroupElements.get(uri);
            resources.addAll(this.parseGroup(groupElement, groups));
        } else {
            throw new WroRuntimeException("Usupported resource type: " + tagName);
        }
        if (type != null) {
            String minimizeAsString = resourceElement.getAttribute(ATTR_MINIMIZE);
            boolean minimize = StringUtils.isEmpty((String)minimizeAsString) ? true : Boolean.valueOf(resourceElement.getAttribute(ATTR_MINIMIZE));
            Resource resource = Resource.create(uri, type);
            resource.setMinimize(minimize);
            resources.add(resource);
        }
    }

    protected static InputStream getResourceAsStream(String fileName) {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);
    }

    private void validate(Document document) throws IOException, SAXException {
        Schema schema = this.getSchema();
        Validator validator = schema.newValidator();
        validator.validate(new DOMSource(document));
    }

    @Override
    public void onCachePeriodChanged() {
    }

    @Override
    public void onModelPeriodChanged() {
        if (this.scheduler != null) {
            this.scheduler.shutdown();
            this.scheduler = null;
        }
        this.model = null;
    }

    @Override
    public void destroy() {
        if (this.scheduler != null) {
            this.scheduler.shutdownNow();
        }
    }
}

