/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.manager.factory.standalone;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.manager.factory.standalone.StandaloneContext;
import ro.isdc.wro.manager.factory.standalone.StandaloneContextAwareManagerFactory;
import ro.isdc.wro.manager.factory.standalone.StandaloneWroManagerFactory;
import ro.isdc.wro.model.factory.WroModelFactory;
import ro.isdc.wro.model.factory.XmlModelFactory;
import ro.isdc.wro.model.group.GroupExtractor;
import ro.isdc.wro.model.group.processor.GroupExtractorDecorator;
import ro.isdc.wro.model.group.processor.GroupsProcessor;
import ro.isdc.wro.model.resource.locator.ServletContextUriLocator;
import ro.isdc.wro.model.resource.processor.impl.BomStripperPreProcessor;
import ro.isdc.wro.model.resource.processor.impl.css.CssImportPreProcessor;
import ro.isdc.wro.model.resource.processor.impl.css.CssUrlRewritingProcessor;
import ro.isdc.wro.model.resource.processor.impl.css.CssVariablesProcessor;
import ro.isdc.wro.model.resource.processor.impl.css.JawrCssMinifierProcessor;
import ro.isdc.wro.model.resource.processor.impl.js.JSMinProcessor;
import ro.isdc.wro.model.resource.processor.impl.js.SemicolonAppenderPreProcessor;
import ro.isdc.wro.model.resource.util.NamingStrategy;
import ro.isdc.wro.model.resource.util.NoOpNamingStrategy;

public class DefaultStandaloneContextAwareManagerFactory
extends StandaloneWroManagerFactory
implements StandaloneContextAwareManagerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultStandaloneContextAwareManagerFactory.class);
    private StandaloneContext standaloneContext;
    private NamingStrategy namingStrategy;

    public void initialize(StandaloneContext standaloneContext) {
        this.standaloneContext = standaloneContext;
    }

    protected GroupExtractor newGroupExtractor() {
        return new GroupExtractorDecorator(super.newGroupExtractor()){

            public boolean isMinimized(HttpServletRequest request) {
                return DefaultStandaloneContextAwareManagerFactory.this.standaloneContext.isMinimize();
            }
        };
    }

    protected WroModelFactory newModelFactory(ServletContext servletContext) {
        return new XmlModelFactory(){

            protected InputStream getConfigResourceAsStream() throws IOException {
                return new FileInputStream(DefaultStandaloneContextAwareManagerFactory.this.standaloneContext.getWroFile());
            }
        };
    }

    protected void configureGroupsProcessor(GroupsProcessor groupsProcessor) {
        super.configureGroupsProcessor(groupsProcessor);
        this.configureProcessors(groupsProcessor);
        groupsProcessor.setIgnoreMissingResources(this.standaloneContext.isIgnoreMissingResources());
    }

    protected void configureProcessors(GroupsProcessor groupsProcessor) {
        groupsProcessor.addPreProcessor(new BomStripperPreProcessor());
        groupsProcessor.addPreProcessor(new CssImportPreProcessor());
        groupsProcessor.addPreProcessor(new CssUrlRewritingProcessor());
        groupsProcessor.addPreProcessor(new SemicolonAppenderPreProcessor());
        groupsProcessor.addPreProcessor(new JSMinProcessor());
        groupsProcessor.addPreProcessor(new JawrCssMinifierProcessor());
        groupsProcessor.addPostProcessor(new CssVariablesProcessor());
    }

    protected ServletContextUriLocator newServletContextUriLocator() {
        return new ServletContextUriLocator(){

            public InputStream locate(String uri) throws IOException {
                if (this.getWildcardStreamLocator().hasWildcard(uri)) {
                    String fullPath = FilenameUtils.getFullPath((String)uri);
                    String realPath = DefaultStandaloneContextAwareManagerFactory.this.standaloneContext.getContextFolder().getPath() + fullPath;
                    return this.getWildcardStreamLocator().locateStream(uri, new File(realPath));
                }
                LOG.debug("locating uri: " + uri);
                String uriWithoutPrefix = uri.replaceFirst("/", "");
                File file = new File(DefaultStandaloneContextAwareManagerFactory.this.standaloneContext.getContextFolder(), uriWithoutPrefix);
                LOG.debug("Opening file: " + file.getPath());
                return new FileInputStream(file);
            }
        };
    }

    public final NamingStrategy getNamingStrategy() {
        if (this.namingStrategy == null) {
            this.namingStrategy = new NoOpNamingStrategy();
        }
        return this.namingStrategy;
    }

    public final void setNamingStrategy(NamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }
}

