/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.manager.factory;

import java.beans.PropertyChangeListener;
import javax.servlet.ServletContext;
import ro.isdc.wro.cache.CacheEntry;
import ro.isdc.wro.cache.CacheStrategy;
import ro.isdc.wro.cache.ContentHashEntry;
import ro.isdc.wro.cache.impl.MapCacheStrategy;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.config.WroConfigurationChangeListener;
import ro.isdc.wro.manager.CacheChangeCallbackAware;
import ro.isdc.wro.manager.WroManager;
import ro.isdc.wro.manager.WroManagerFactory;
import ro.isdc.wro.model.factory.ServletContextAwareXmlModelFactory;
import ro.isdc.wro.model.factory.WroModelFactory;
import ro.isdc.wro.model.group.DefaultGroupExtractor;
import ro.isdc.wro.model.group.GroupExtractor;
import ro.isdc.wro.model.group.processor.GroupsProcessor;
import ro.isdc.wro.model.resource.factory.UriLocatorFactory;
import ro.isdc.wro.model.resource.util.HashBuilder;
import ro.isdc.wro.model.resource.util.MD5HashBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseWroManagerFactory
implements WroManagerFactory,
WroConfigurationChangeListener,
CacheChangeCallbackAware {
    protected volatile WroManager manager;
    private PropertyChangeListener cacheChangeCallback;

    protected BaseWroManagerFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final WroManager getInstance() {
        if (this.manager == null) {
            BaseWroManagerFactory baseWroManagerFactory = this;
            synchronized (baseWroManagerFactory) {
                if (this.manager == null) {
                    GroupExtractor groupExtractor = this.newGroupExtractor();
                    WroModelFactory modelFactory = this.newModelFactory(Context.get().getServletContext());
                    GroupsProcessor groupsProcessor = new GroupsProcessor(){

                        protected void configureUriLocatorFactory(UriLocatorFactory uriLocatorFactory) {
                            BaseWroManagerFactory.this.configureUriLocatorFactory(uriLocatorFactory);
                        }
                    };
                    this.configureGroupsProcessor(groupsProcessor);
                    CacheStrategy<CacheEntry, ContentHashEntry> cacheStrategy = this.newCacheStrategy();
                    this.manager = this.newManager();
                    this.manager.setGroupExtractor(groupExtractor);
                    this.manager.setModelFactory(modelFactory);
                    this.manager.setGroupsProcessor(groupsProcessor);
                    this.manager.setCacheStrategy(cacheStrategy);
                    this.manager.setHashBuilder(this.newHashBuilder());
                    this.manager.registerCallback(this.cacheChangeCallback);
                }
            }
        }
        return this.manager;
    }

    protected void configureUriLocatorFactory(UriLocatorFactory factory) {
    }

    protected HashBuilder newHashBuilder() {
        return new MD5HashBuilder();
    }

    @Override
    public void registerCallback(PropertyChangeListener callback) {
        this.cacheChangeCallback = callback;
    }

    protected WroManager newManager() {
        return new WroManager();
    }

    @Override
    public void onCachePeriodChanged() {
        if (this.manager != null) {
            this.manager.onCachePeriodChanged();
        }
    }

    @Override
    public void onModelPeriodChanged() {
        if (this.manager != null) {
            this.manager.onModelPeriodChanged();
            this.manager.onCachePeriodChanged();
        }
    }

    protected CacheStrategy<CacheEntry, ContentHashEntry> newCacheStrategy() {
        return new MapCacheStrategy<CacheEntry, ContentHashEntry>();
    }

    protected GroupExtractor newGroupExtractor() {
        return new DefaultGroupExtractor();
    }

    protected WroModelFactory newModelFactory(ServletContext servletContext) {
        return new ServletContextAwareXmlModelFactory();
    }

    protected void configureGroupsProcessor(GroupsProcessor groupsProcessor) {
    }

    @Override
    public void destroy() {
        if (this.manager != null) {
            this.manager.destroy();
        }
    }
}

