/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.config.jmx;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.config.jmx.WroConfigurationMBean;

public final class WroConfiguration
implements WroConfigurationMBean {
    private static final Logger LOG = LoggerFactory.getLogger(WroConfiguration.class);
    private long cacheUpdatePeriod;
    private long modelUpdatePeriod;
    private boolean gzipEnabled = true;
    private boolean debug;
    private final List<PropertyChangeListener> cacheUpdatePeriodListeners = new ArrayList<PropertyChangeListener>(1);
    private final List<PropertyChangeListener> modelUpdatePeriodListeners = new ArrayList<PropertyChangeListener>(1);

    public static String getObjectName() {
        return WroConfiguration.class.getPackage().getName() + ".jmx:type=" + WroConfiguration.class.getSimpleName();
    }

    public long getCacheUpdatePeriod() {
        return this.cacheUpdatePeriod;
    }

    public long getModelUpdatePeriod() {
        return this.modelUpdatePeriod;
    }

    public void setCacheUpdatePeriod(long period) {
        if (period != this.cacheUpdatePeriod) {
            this.reloadCacheWithNewValue(period);
        }
        this.cacheUpdatePeriod = period;
    }

    public void setModelUpdatePeriod(long period) {
        if (period != this.modelUpdatePeriod) {
            this.reloadModelWithNewValue(period);
        }
        this.modelUpdatePeriod = period;
    }

    public boolean isGzipEnabled() {
        return this.gzipEnabled;
    }

    public void setGzipEnabled(boolean enable) {
        this.gzipEnabled = enable;
    }

    public void reloadCache() {
        this.reloadCacheWithNewValue(null);
    }

    private void reloadCacheWithNewValue(Long newValue) {
        long newValueAsPrimitive = newValue == null ? this.getModelUpdatePeriod() : newValue.longValue();
        LOG.debug("invoking " + this.cacheUpdatePeriodListeners.size() + " listeners");
        for (PropertyChangeListener listener : this.cacheUpdatePeriodListeners) {
            PropertyChangeEvent event = new PropertyChangeEvent(this, "cache", this.getCacheUpdatePeriod(), newValueAsPrimitive);
            listener.propertyChange(event);
        }
    }

    public void reloadModel() {
        LOG.debug("reloadModel");
        this.reloadModelWithNewValue(null);
    }

    private void reloadModelWithNewValue(Long newValue) {
        long newValueAsPrimitive = newValue == null ? this.getModelUpdatePeriod() : newValue.longValue();
        for (PropertyChangeListener listener : this.modelUpdatePeriodListeners) {
            PropertyChangeEvent event = new PropertyChangeEvent(this, "model", this.getModelUpdatePeriod(), newValueAsPrimitive);
            listener.propertyChange(event);
        }
    }

    public void registerModelUpdatePeriodChangeListener(PropertyChangeListener listener) {
        this.modelUpdatePeriodListeners.add(listener);
    }

    public void registerCacheUpdatePeriodChangeListener(PropertyChangeListener listener) {
        this.cacheUpdatePeriodListeners.add(listener);
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void destroy() {
        this.cacheUpdatePeriodListeners.clear();
        this.modelUpdatePeriodListeners.clear();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).append("debug", this.debug).append("gzipEnabled", this.gzipEnabled).append("cacheUpdatePeriod", this.cacheUpdatePeriod).append("modelUpdatePeriod", this.modelUpdatePeriod).toString();
    }
}

