/*
 * Decompiled with CFR 0.152.
 */
package org.xBaseJ;

import java.io.CharArrayWriter;
import java.io.FileReader;
import java.io.IOException;
import org.apache.xerces.parsers.SAXParser;
import org.xBaseJ.DBF;
import org.xBaseJ.fields.CharField;
import org.xBaseJ.fields.DateField;
import org.xBaseJ.fields.Field;
import org.xBaseJ.fields.FloatField;
import org.xBaseJ.fields.LogicalField;
import org.xBaseJ.fields.MemoField;
import org.xBaseJ.fields.NumField;
import org.xBaseJ.fields.PictureField;
import org.xBaseJ.xBaseJException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XBASEXMLParser
extends DefaultHandler {
    public SAXParser parser;
    private CharArrayWriter contents = new CharArrayWriter();
    private int iLine = 0;
    private int iElement = 0;
    boolean recordProcessing = false;
    private DBF dbf;
    private Field fld;
    private String fldName;
    private char fldType;

    public static void main(String[] args) {
        new XBASEXMLParser().parse(args[0]);
    }

    public XBASEXMLParser() {
        try {
            this.parser = new SAXParser();
            this.parser.setFeature("http://xml.org/sax/features/namespaces", false);
            this.parser.setFeature("http://xml.org/sax/features/validation", true);
            this.parser.setContentHandler((ContentHandler)this);
            this.parser.setErrorHandler((ErrorHandler)this);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public void parse(String inXMLFile) {
        try {
            FileReader fr = new FileReader(inXMLFile);
            InputSource is = new InputSource(fr);
            this.parser.parse(is);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public void startElement(String uri, String localName, String rawName, Attributes attributes) throws SAXException {
        ++this.iElement;
        this.contents.reset();
        try {
            if (rawName.compareTo("dbf") == 0) {
                String dbfName = attributes.getValue("name");
                String dbfEncoding = attributes.getValue("encoding");
                this.dbf = dbfEncoding.length() == 0 ? new DBF(dbfName, true) : new DBF(dbfName, true, dbfEncoding);
            } else if (rawName.compareTo("field") == 0) {
                this.fldName = attributes.getValue("name");
                if (!this.recordProcessing) {
                    this.fldType = attributes.getValue("type").charAt(0);
                    switch (this.fldType) {
                        case 'C': {
                            int fl = Integer.parseInt(attributes.getValue("length"));
                            this.dbf.addField(new CharField(this.fldName, fl));
                            break;
                        }
                        case 'D': {
                            this.dbf.addField(new DateField(this.fldName));
                            break;
                        }
                        case 'F': {
                            int fl = Integer.parseInt(attributes.getValue("length"));
                            int dp = Integer.parseInt(attributes.getValue("decimalPos"));
                            this.dbf.addField(new FloatField(this.fldName, fl, dp));
                            break;
                        }
                        case 'N': {
                            int fl = Integer.parseInt(attributes.getValue("length"));
                            int dp = Integer.parseInt(attributes.getValue("decimalPos"));
                            this.dbf.addField(new NumField(this.fldName, fl, dp));
                            break;
                        }
                        case 'L': {
                            this.dbf.addField(new LogicalField(this.fldName));
                            break;
                        }
                        case 'M': {
                            this.dbf.addField(new MemoField(this.fldName));
                            break;
                        }
                        case 'P': {
                            this.dbf.addField(new PictureField(this.fldName));
                        }
                    }
                } else {
                    this.fld = this.dbf.getField(this.fldName);
                }
            } else if (rawName.compareTo("record") == 0) {
                this.recordProcessing = true;
            } else {
                System.err.println("Logic error: Unknown element name \"" + rawName + "\" found at element position " + this.iElement + " line: " + this.iLine);
            }
        }
        catch (xBaseJException xbe) {
            throw new SAXException("org.xBaseJ error: " + xbe.getMessage());
        }
        catch (IOException ioe) {
            throw new SAXException("java.IOExcpetion: " + ioe.getMessage());
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.contents.write(ch, start, length);
    }

    public void endElement(String uri, String localName, String rawName) throws SAXException {
        String data = this.contents.toString();
        try {
            if (rawName.compareTo("dbf") != 0) {
                if (rawName.compareTo("field") == 0) {
                    if (this.recordProcessing) {
                        this.fld.put(data);
                    }
                } else if (rawName.compareTo("record") == 0) {
                    this.dbf.write();
                }
            }
        }
        catch (xBaseJException xbe) {
            throw new SAXException("org.xBaseJ error: " + xbe.getMessage());
        }
        catch (IOException ioe) {
            throw new SAXException("java.IOExcpetion: " + ioe.getMessage());
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) {
        for (int i = start; i < start + length; ++i) {
            if (ch[i] != '\n') continue;
            ++this.iLine;
        }
    }

    public void warning(SAXParseException e) throws SAXException {
        System.err.println("Warning at (file " + e.getSystemId() + ", line " + e.getLineNumber() + ", char " + e.getColumnNumber() + "): " + e.getMessage());
    }

    public void error(SAXParseException e) throws SAXException {
        throw new SAXException("Error at (file " + e.getSystemId() + ", line " + e.getLineNumber() + ", char " + e.getColumnNumber() + "): " + e.getMessage());
    }

    public void fatalError(SAXParseException e) throws SAXException {
        throw new SAXException("Fatal Error at (file " + e.getSystemId() + ", line " + e.getLineNumber() + ", char " + e.getColumnNumber() + "): " + e.getMessage());
    }
}

