/*
 * Decompiled with CFR 0.152.
 */
package org.xBaseJ;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.xBaseJ.DBF;
import org.xBaseJ.Util;
import org.xBaseJ.xBaseJException;

public abstract class DBTFile {
    public RandomAccessFile file;
    public boolean open;
    public File thefile;
    public int memoBlockSize = 512;
    public int nextBlock;
    public DBF database;
    public static final byte BYTEZERO = 48;
    public static final byte BYTESPACE = 32;
    public String extension = "dbt";

    public void rename(String name) throws IOException {
        String tname = new String(name.substring(0, name.length() - 1) + "t");
        this.file.close();
        File nfile = new File(tname);
        nfile.delete();
        this.thefile.renameTo(nfile);
        this.thefile = nfile;
        this.file = new RandomAccessFile(tname, "rw");
    }

    public DBTFile(DBF iDBF, boolean readonly, int type) throws IOException, xBaseJException, IOException {
        String tname;
        this.database = iDBF;
        String name = iDBF.getName();
        String ext = Util.getxBaseJProperty("memoFileExtension");
        if (ext.length() > 0) {
            tname = new String(name.substring(0, name.length() - 3) + ext);
            this.extension = ext;
        } else if (type == -11) {
            this.extension = "fpt";
            tname = new String(name.substring(0, name.length() - 3) + this.extension);
            this.thefile = new File(tname);
            if (!this.thefile.exists() || !this.thefile.isFile()) {
                throw new xBaseJException("Can't find Memo Text file " + tname);
            }
        } else {
            tname = new String(name.substring(0, name.length() - 3) + this.extension);
            this.thefile = new File(tname);
            if (!this.thefile.exists() || !this.thefile.isFile()) {
                String dtname = new String(name.substring(0, name.length() - 3) + "fpt");
                this.thefile = new File(dtname);
                if (!this.thefile.exists() || !this.thefile.isFile()) {
                    throw new xBaseJException("Can't find Memo Text file " + dtname);
                }
                tname = dtname;
            }
        }
        this.file = readonly ? new RandomAccessFile(tname, "r") : new RandomAccessFile(tname, "rw");
        this.setNextBlock();
    }

    public DBTFile(DBF iDBF, String name, boolean destroy, int type) throws IOException, xBaseJException {
        this.database = iDBF;
        String ext = Util.getxBaseJProperty("memoFileExtension");
        if (ext.length() > 0) {
            this.extension = ext;
        } else if (type == -11) {
            this.extension = "fpt";
        }
        String tname = new String(name.substring(0, name.length() - 3) + this.extension);
        this.thefile = new File(tname);
        if (!destroy && this.thefile.exists()) {
            throw new xBaseJException("Memeo Text File exists, can't destroy");
        }
        if (destroy && this.thefile.exists() && !this.thefile.delete()) {
            throw new xBaseJException("Can't delete old Memo Text file");
        }
        FileOutputStream tFOS = new FileOutputStream(this.thefile);
        tFOS.close();
        this.file = new RandomAccessFile(this.thefile, "rw");
        this.setNextBlock();
    }

    public abstract void setNextBlock() throws IOException;

    public abstract byte[] readBytes(byte[] var1) throws IOException, xBaseJException;

    public abstract byte[] write(String var1, int var2, boolean var3, byte[] var4) throws IOException, xBaseJException;

    public void seek(int pos) throws IOException {
        long lpos = pos;
        this.file.seek(lpos);
    }

    public void close() throws IOException {
        this.open = false;
        this.file.close();
    }
}

