/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.server.endpoint.interceptor;

import javax.xml.transform.Source;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.endpoint.AbstractLoggingInterceptor;
import org.springframework.ws.soap.SoapHeaderElement;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.ws.soap.server.SoapEndpointInterceptor;

public class SoapEnvelopeLoggingInterceptor
extends AbstractLoggingInterceptor
implements SoapEndpointInterceptor {
    private boolean logFault = true;

    public void setLogFault(boolean logFault) {
        this.logFault = logFault;
    }

    public boolean handleFault(MessageContext messageContext, Object endpoint) throws Exception {
        if (this.logFault && this.logger.isDebugEnabled()) {
            this.logMessageSource("Fault: ", this.getSource(messageContext.getResponse()));
        }
        return true;
    }

    public boolean understands(SoapHeaderElement header) {
        return false;
    }

    protected Source getSource(WebServiceMessage message) {
        if (message instanceof SoapMessage) {
            SoapMessage soapMessage = (SoapMessage)message;
            return soapMessage.getEnvelope().getSource();
        }
        return null;
    }
}

