/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.security.xwss.callback;

import com.sun.xml.wss.impl.callback.PasswordValidationCallback;
import com.sun.xml.wss.impl.callback.TimestampValidationCallback;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.ws.soap.security.callback.AbstractCallbackHandler;
import org.springframework.ws.soap.security.xwss.callback.DefaultTimestampValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimplePasswordValidationCallbackHandler
extends AbstractCallbackHandler
implements InitializingBean {
    private Map<String, String> users = new HashMap<String, String>();

    public void setUsers(Properties users) {
        for (Map.Entry<Object, Object> entry : users.entrySet()) {
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
            this.users.put((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public void setUsersMap(Map<String, String> users) {
        this.users = users;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.users, (String)"users is required");
    }

    @Override
    protected void handleInternal(Callback callback) throws IOException, UnsupportedCallbackException {
        if (callback instanceof PasswordValidationCallback) {
            PasswordValidationCallback passwordCallback = (PasswordValidationCallback)callback;
            if (passwordCallback.getRequest() instanceof PasswordValidationCallback.PlainTextPasswordRequest) {
                passwordCallback.setValidator((PasswordValidationCallback.PasswordValidator)new SimplePlainTextPasswordValidator());
            } else if (passwordCallback.getRequest() instanceof PasswordValidationCallback.DigestPasswordRequest) {
                PasswordValidationCallback.DigestPasswordRequest digestPasswordRequest = (PasswordValidationCallback.DigestPasswordRequest)passwordCallback.getRequest();
                String password = this.users.get(digestPasswordRequest.getUsername());
                digestPasswordRequest.setPassword(password);
                passwordCallback.setValidator((PasswordValidationCallback.PasswordValidator)new PasswordValidationCallback.DigestPasswordValidator());
            }
        } else if (callback instanceof TimestampValidationCallback) {
            TimestampValidationCallback timestampCallback = (TimestampValidationCallback)callback;
            timestampCallback.setValidator((TimestampValidationCallback.TimestampValidator)new DefaultTimestampValidator());
        } else {
            throw new UnsupportedCallbackException(callback);
        }
    }

    private class SimplePlainTextPasswordValidator
    implements PasswordValidationCallback.PasswordValidator {
        private SimplePlainTextPasswordValidator() {
        }

        public boolean validate(PasswordValidationCallback.Request request) throws PasswordValidationCallback.PasswordValidationException {
            PasswordValidationCallback.PlainTextPasswordRequest plainTextPasswordRequest = (PasswordValidationCallback.PlainTextPasswordRequest)request;
            String password = (String)SimplePasswordValidationCallbackHandler.this.users.get(plainTextPasswordRequest.getUsername());
            return password != null && password.equals(plainTextPasswordRequest.getPassword());
        }
    }
}

