/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.security.x509.cache;

import java.io.Serializable;
import java.security.cert.X509Certificate;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.Assert;
import org.springframework.ws.soap.security.x509.cache.X509UserCache;

public class EhCacheBasedX509UserCache
implements X509UserCache,
InitializingBean {
    private static final Log logger = LogFactory.getLog(EhCacheBasedX509UserCache.class);
    private Ehcache cache;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.cache, (String)"cache is mandatory");
    }

    public UserDetails getUserFromCache(X509Certificate userCert) {
        Element element = null;
        try {
            element = this.cache.get((Serializable)userCert);
        }
        catch (CacheException cacheException) {
            throw new DataRetrievalFailureException("Cache failure: " + cacheException.getMessage());
        }
        if (logger.isDebugEnabled()) {
            String subjectDN = "unknown";
            if (userCert != null && userCert.getSubjectDN() != null) {
                subjectDN = ((Object)userCert.getSubjectDN()).toString();
            }
            logger.debug((Object)("X.509 Cache hit. SubjectDN: " + subjectDN));
        }
        if (element == null) {
            return null;
        }
        return (UserDetails)element.getValue();
    }

    public void putUserInCache(X509Certificate userCert, UserDetails user) {
        Element element = new Element((Serializable)userCert, (Serializable)user);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cache put: " + userCert.getSubjectDN()));
        }
        this.cache.put(element);
    }

    public void removeUserFromCache(X509Certificate userCert) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cache remove: " + userCert.getSubjectDN()));
        }
        this.cache.remove((Serializable)userCert);
    }

    public void setCache(Ehcache cache) {
        this.cache = cache;
    }
}

