/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.saaj;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.ws.mime.Attachment;
import org.springframework.ws.mime.AttachmentException;
import org.springframework.ws.soap.AbstractSoapMessage;
import org.springframework.ws.soap.SoapEnvelope;
import org.springframework.ws.soap.SoapVersion;
import org.springframework.ws.soap.saaj.Saaj11Implementation;
import org.springframework.ws.soap.saaj.Saaj12Implementation;
import org.springframework.ws.soap.saaj.Saaj13Implementation;
import org.springframework.ws.soap.saaj.SaajAttachment;
import org.springframework.ws.soap.saaj.SaajImplementation;
import org.springframework.ws.soap.saaj.SaajSoapEnvelope;
import org.springframework.ws.soap.saaj.SaajSoapEnvelopeException;
import org.springframework.ws.soap.saaj.SaajSoapMessageException;
import org.springframework.ws.soap.saaj.support.SaajUtils;
import org.springframework.ws.soap.support.SoapUtils;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaajSoapMessage
extends AbstractSoapMessage {
    private static final String CONTENT_TYPE_XOP = "application/xop+xml";
    private final MessageFactory messageFactory;
    private SOAPMessage saajMessage;
    private SoapEnvelope envelope;
    private final boolean langAttributeOnSoap11FaultString;
    private SaajImplementation implementation;

    public SaajSoapMessage(SOAPMessage soapMessage) {
        this(soapMessage, true, null);
    }

    public SaajSoapMessage(SOAPMessage soapMessage, MessageFactory messageFactory) {
        this(soapMessage, true, messageFactory);
    }

    public SaajSoapMessage(SOAPMessage soapMessage, boolean langAttributeOnSoap11FaultString) {
        this(soapMessage, langAttributeOnSoap11FaultString, null);
    }

    public SaajSoapMessage(SOAPMessage soapMessage, boolean langAttributeOnSoap11FaultString, MessageFactory messageFactory) {
        Assert.notNull((Object)soapMessage, (String)"soapMessage must not be null");
        this.saajMessage = soapMessage;
        this.langAttributeOnSoap11FaultString = langAttributeOnSoap11FaultString;
        MimeHeaders headers = this.getImplementation().getMimeHeaders(soapMessage);
        if (ObjectUtils.isEmpty((Object[])headers.getHeader("SOAPAction"))) {
            headers.addHeader("SOAPAction", "\"\"");
        }
        this.messageFactory = messageFactory;
    }

    public SOAPMessage getSaajMessage() {
        return this.saajMessage;
    }

    public void setSaajMessage(SOAPMessage soapMessage) {
        Assert.notNull((Object)soapMessage, (String)"soapMessage must not be null");
        this.saajMessage = soapMessage;
        this.envelope = null;
    }

    @Override
    public SoapEnvelope getEnvelope() {
        if (this.envelope == null) {
            try {
                SOAPEnvelope saajEnvelope = this.getImplementation().getEnvelope(this.getSaajMessage());
                this.envelope = new SaajSoapEnvelope(saajEnvelope, this.langAttributeOnSoap11FaultString);
            }
            catch (SOAPException ex) {
                throw new SaajSoapEnvelopeException(ex);
            }
        }
        return this.envelope;
    }

    @Override
    public String getSoapAction() {
        MimeHeaders mimeHeaders = this.getImplementation().getMimeHeaders(this.getSaajMessage());
        if (SoapVersion.SOAP_11 == this.getVersion()) {
            Object[] actions = mimeHeaders.getHeader("SOAPAction");
            return ObjectUtils.isEmpty((Object[])actions) ? "\"\"" : actions[0];
        }
        if (SoapVersion.SOAP_12 == this.getVersion()) {
            Object[] contentTypes = mimeHeaders.getHeader("Content-Type");
            return !ObjectUtils.isEmpty((Object[])contentTypes) ? SoapUtils.extractActionFromContentType((String)contentTypes[0]) : "\"\"";
        }
        throw new IllegalStateException("Unsupported SOAP version: " + this.getVersion());
    }

    @Override
    public void setSoapAction(String soapAction) {
        MimeHeaders mimeHeaders = this.getImplementation().getMimeHeaders(this.getSaajMessage());
        soapAction = SoapUtils.escapeAction(soapAction);
        if (SoapVersion.SOAP_11 == this.getVersion()) {
            mimeHeaders.setHeader("SOAPAction", soapAction);
        } else if (SoapVersion.SOAP_12 == this.getVersion()) {
            Object[] contentTypes;
            if (this.saajMessage.saveRequired()) {
                try {
                    this.saajMessage.saveChanges();
                }
                catch (SOAPException ex) {
                    throw new SaajSoapMessageException("Could not save message", ex);
                }
            }
            Object contentType = !ObjectUtils.isEmpty((Object[])(contentTypes = mimeHeaders.getHeader("Content-Type"))) ? contentTypes[0] : this.getVersion().getContentType();
            contentType = SoapUtils.setActionInContentType((String)contentType, soapAction);
            mimeHeaders.setHeader("Content-Type", (String)contentType);
            mimeHeaders.removeHeader("SOAPAction");
        } else {
            throw new IllegalStateException("Unsupported SOAP version: " + this.getVersion());
        }
    }

    @Override
    public Document getDocument() {
        Assert.state((this.messageFactory != null ? 1 : 0) != 0, (String)"Could find message factory to use");
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            this.getSaajMessage().writeTo((OutputStream)bos);
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            SOAPMessage saajMessage = this.messageFactory.createMessage(this.getSaajMessage().getMimeHeaders(), (InputStream)bis);
            this.setSaajMessage(saajMessage);
            return saajMessage.getSOAPPart();
        }
        catch (SOAPException ex) {
            throw new SaajSoapMessageException("Could not save changes", ex);
        }
        catch (IOException ex) {
            throw new SaajSoapMessageException("Could not save changes", ex);
        }
    }

    @Override
    public void setDocument(Document document) {
        if (this.saajMessage.getSOAPPart() != document) {
            Assert.state((this.messageFactory != null ? 1 : 0) != 0, (String)"Could find message factory to use");
            try {
                DOMImplementation implementation = document.getImplementation();
                Assert.isInstanceOf(DOMImplementationLS.class, (Object)implementation);
                DOMImplementationLS loadSaveImplementation = (DOMImplementationLS)((Object)implementation);
                LSOutput output = loadSaveImplementation.createLSOutput();
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                output.setByteStream(bos);
                LSSerializer serializer = loadSaveImplementation.createLSSerializer();
                serializer.write(document, output);
                ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
                this.saajMessage = this.messageFactory.createMessage(this.saajMessage.getMimeHeaders(), (InputStream)bis);
            }
            catch (SOAPException ex) {
                throw new SaajSoapMessageException("Could not read input stream", ex);
            }
            catch (IOException ex) {
                throw new SaajSoapMessageException("Could not read input stream", ex);
            }
        }
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        MimeHeaders mimeHeaders = this.getImplementation().getMimeHeaders(this.getSaajMessage());
        if (ObjectUtils.isEmpty((Object[])mimeHeaders.getHeader("Accept"))) {
            mimeHeaders.setHeader("Accept", this.getVersion().getContentType());
        }
        try {
            this.getImplementation().writeTo(this.getSaajMessage(), outputStream);
            outputStream.flush();
        }
        catch (SOAPException ex) {
            throw new SaajSoapMessageException("Could not write message to OutputStream: " + ex.getMessage(), ex);
        }
    }

    private int getSaajVersion() {
        try {
            return SaajUtils.getSaajVersion(this.saajMessage);
        }
        catch (SOAPException ex) {
            throw new SaajSoapEnvelopeException("Could not access envelope: " + ex.getMessage(), ex);
        }
    }

    @Override
    public boolean isXopPackage() {
        if (this.getSaajVersion() >= 2) {
            String[] contentTypes;
            SOAPPart saajPart = this.saajMessage.getSOAPPart();
            for (String contentType : contentTypes = saajPart.getMimeHeader("Content-Type")) {
                if (contentType.indexOf(CONTENT_TYPE_XOP) == -1) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean convertToXopPackage() {
        if (this.getSaajVersion() >= 2) {
            this.convertMessageToXop();
            this.convertPartToXop();
            return true;
        }
        return false;
    }

    private void convertMessageToXop() {
        MimeHeaders mimeHeaders = this.saajMessage.getMimeHeaders();
        Object[] oldContentTypes = mimeHeaders.getHeader("Content-Type");
        Object oldContentType = !ObjectUtils.isEmpty((Object[])oldContentTypes) ? oldContentTypes[0] : this.getVersion().getContentType();
        StringBuilder builder = new StringBuilder(CONTENT_TYPE_XOP);
        builder.append(";type=");
        builder.append('\"');
        builder.append((String)oldContentType);
        builder.append('\"');
        mimeHeaders.setHeader("Content-Type", builder.toString());
    }

    private void convertPartToXop() {
        SOAPPart saajPart = this.saajMessage.getSOAPPart();
        Object[] oldContentTypes = saajPart.getMimeHeader("Content-Type");
        Object oldContentType = !ObjectUtils.isEmpty((Object[])oldContentTypes) ? oldContentTypes[0] : this.getVersion().getContentType();
        StringBuilder builder = new StringBuilder(CONTENT_TYPE_XOP);
        builder.append(";type=");
        builder.append('\"');
        builder.append((String)oldContentType);
        builder.append('\"');
        saajPart.setMimeHeader("Content-Type", builder.toString());
    }

    @Override
    public Iterator<Attachment> getAttachments() throws AttachmentException {
        Iterator<AttachmentPart> iterator = this.getImplementation().getAttachments(this.getSaajMessage());
        return new SaajAttachmentIterator(iterator);
    }

    @Override
    public Attachment getAttachment(String contentId) {
        Assert.hasLength((String)contentId, (String)"contentId must not be empty");
        MimeHeaders mimeHeaders = new MimeHeaders();
        mimeHeaders.setHeader("Content-Id", contentId);
        Iterator<AttachmentPart> iterator = this.getImplementation().getAttachment(this.getSaajMessage(), mimeHeaders);
        if (!iterator.hasNext()) {
            return null;
        }
        AttachmentPart saajAttachment = iterator.next();
        return new SaajAttachment(saajAttachment);
    }

    @Override
    public Attachment addAttachment(String contentId, DataHandler dataHandler) {
        Assert.hasLength((String)contentId, (String)"contentId must not be empty");
        Assert.notNull((Object)dataHandler, (String)"dataHandler must not be null");
        AttachmentPart saajAttachment = this.getImplementation().addAttachmentPart(this.getSaajMessage(), dataHandler);
        saajAttachment.setContentId(contentId);
        saajAttachment.setMimeHeader("Content-Transfer-Encoding", "binary");
        return new SaajAttachment(saajAttachment);
    }

    protected final SaajImplementation getImplementation() {
        if (this.implementation == null) {
            int saajVersion = this.getSaajVersion();
            if (saajVersion == 2) {
                this.implementation = Saaj13Implementation.getInstance();
            } else if (saajVersion == 1) {
                this.implementation = Saaj12Implementation.getInstance();
            } else if (saajVersion == 0) {
                this.implementation = Saaj11Implementation.getInstance();
            } else {
                throw new IllegalStateException("Could not find SAAJ on the classpath");
            }
        }
        return this.implementation;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SaajSoapMessage");
        try {
            SOAPElement bodyElement;
            SOAPBody body;
            SOAPEnvelope envelope = this.getImplementation().getEnvelope(this.saajMessage);
            if (envelope != null && (body = this.getImplementation().getBody(envelope)) != null && (bodyElement = this.getImplementation().getFirstBodyElement(body)) != null) {
                builder.append(' ');
                builder.append(this.getImplementation().getName(bodyElement));
            }
        }
        catch (SOAPException sOAPException) {
            // empty catch block
        }
        return builder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SaajAttachmentIterator
    implements Iterator<Attachment> {
        private final Iterator<AttachmentPart> saajIterator;

        private SaajAttachmentIterator(Iterator<AttachmentPart> saajIterator) {
            this.saajIterator = saajIterator;
        }

        @Override
        public boolean hasNext() {
            return this.saajIterator.hasNext();
        }

        @Override
        public Attachment next() {
            AttachmentPart saajAttachment = this.saajIterator.next();
            return new SaajAttachment(saajAttachment);
        }

        @Override
        public void remove() {
            this.saajIterator.remove();
        }
    }
}

