/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.resource;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.util.StringUtils;
import org.springframework.web.context.support.ServletContextResource;
import org.springframework.web.servlet.resource.AbstractResourceResolver;
import org.springframework.web.servlet.resource.ResourceResolverChain;
import org.springframework.web.util.UriUtils;
import org.springframework.web.util.UrlPathHelper;

public class PathResourceResolver
extends AbstractResourceResolver {
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private Resource[] allowedLocations;
    private final Map<Resource, Charset> locationCharsets = new HashMap<Resource, Charset>(4);
    private UrlPathHelper urlPathHelper;

    public void setAllowedLocations(Resource ... locations) {
        this.allowedLocations = locations;
    }

    public Resource[] getAllowedLocations() {
        return this.allowedLocations;
    }

    public void setLocationCharsets(Map<Resource, Charset> locationCharsets) {
        this.locationCharsets.clear();
        this.locationCharsets.putAll(locationCharsets);
    }

    public Map<Resource, Charset> getLocationCharsets() {
        return Collections.unmodifiableMap(this.locationCharsets);
    }

    public void setUrlPathHelper(UrlPathHelper urlPathHelper) {
        this.urlPathHelper = urlPathHelper;
    }

    public UrlPathHelper getUrlPathHelper() {
        return this.urlPathHelper;
    }

    @Override
    protected Resource resolveResourceInternal(HttpServletRequest request, String requestPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        return this.getResource(requestPath, request, locations);
    }

    @Override
    protected String resolveUrlPathInternal(String resourcePath, List<? extends Resource> locations, ResourceResolverChain chain) {
        return StringUtils.hasText((String)resourcePath) && this.getResource(resourcePath, null, locations) != null ? resourcePath : null;
    }

    private Resource getResource(String resourcePath, HttpServletRequest request, List<? extends Resource> locations) {
        for (Resource resource : locations) {
            try {
                String pathToUse;
                Resource resource2;
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("Checking location: " + resource));
                }
                if ((resource2 = this.getResource(pathToUse = this.encodeIfNecessary(resourcePath, request, resource), resource)) != null) {
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace((Object)("Found match: " + resource2));
                    }
                    return resource2;
                }
                if (!this.logger.isTraceEnabled()) continue;
                this.logger.trace((Object)("No match for location: " + resource));
            }
            catch (IOException ex) {
                this.logger.trace((Object)"Failure checking for relative resource - trying next location", (Throwable)ex);
            }
        }
        return null;
    }

    protected Resource getResource(String resourcePath, Resource location) throws IOException {
        Resource resource = location.createRelative(resourcePath);
        if (resource.exists() && resource.isReadable()) {
            if (this.checkResource(resource, location)) {
                return resource;
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Resource path=\"" + resourcePath + "\" was successfully resolved but resource=\"" + resource.getURL() + "\" is neither under the current location=\"" + location.getURL() + "\" nor under any of the allowed locations=" + Arrays.asList(this.getAllowedLocations())));
            }
        }
        return null;
    }

    protected boolean checkResource(Resource resource, Resource location) throws IOException {
        if (this.isResourceUnderLocation(resource, location)) {
            return true;
        }
        if (this.getAllowedLocations() != null) {
            for (Resource current : this.getAllowedLocations()) {
                if (!this.isResourceUnderLocation(resource, current)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isResourceUnderLocation(Resource resource, Resource location) throws IOException {
        String locationPath;
        String resourcePath;
        if (resource.getClass() != location.getClass()) {
            return false;
        }
        if (resource instanceof UrlResource) {
            resourcePath = resource.getURL().toExternalForm();
            locationPath = StringUtils.cleanPath((String)location.getURL().toString());
        } else if (resource instanceof ClassPathResource) {
            resourcePath = ((ClassPathResource)resource).getPath();
            locationPath = StringUtils.cleanPath((String)((ClassPathResource)location).getPath());
        } else if (resource instanceof ServletContextResource) {
            resourcePath = ((ServletContextResource)resource).getPath();
            locationPath = StringUtils.cleanPath((String)((ServletContextResource)location).getPath());
        } else {
            resourcePath = resource.getURL().getPath();
            locationPath = StringUtils.cleanPath((String)location.getURL().getPath());
        }
        if (locationPath.equals(resourcePath)) {
            return true;
        }
        String string = locationPath = locationPath.endsWith("/") || locationPath.isEmpty() ? locationPath : locationPath + "/";
        if (!resourcePath.startsWith(locationPath)) {
            return false;
        }
        if (resourcePath.contains("%") && URLDecoder.decode(resourcePath, "UTF-8").contains("../")) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Resolved resource path contains \"../\" after decoding: " + resourcePath));
            }
            return false;
        }
        return true;
    }

    private String encodeIfNecessary(String path, HttpServletRequest request, Resource location) {
        if (this.shouldEncodeRelativePath(location) && request != null) {
            Charset charset = this.locationCharsets.get(location);
            charset = charset != null ? charset : DEFAULT_CHARSET;
            StringBuilder sb = new StringBuilder();
            StringTokenizer tokenizer = new StringTokenizer(path, "/");
            while (tokenizer.hasMoreTokens()) {
                String value = null;
                try {
                    value = UriUtils.encode((String)tokenizer.nextToken(), (String)charset.name());
                }
                catch (UnsupportedEncodingException ex) {
                    throw new IllegalStateException("Unexpected error", ex);
                }
                sb.append(value);
                sb.append("/");
            }
            if (!path.endsWith("/")) {
                sb.setLength(sb.length() - 1);
            }
            return sb.toString();
        }
        return path;
    }

    private boolean shouldEncodeRelativePath(Resource location) {
        return location instanceof UrlResource && this.urlPathHelper != null && this.urlPathHelper.isUrlDecode();
    }
}

