/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket;

import java.net.URI;
import java.security.Principal;
import org.springframework.http.HttpHeaders;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class HandshakeInfo {
    private final URI uri;
    private final Mono<Principal> principalMono;
    private final HttpHeaders headers;
    @Nullable
    private final String protocol;

    public HandshakeInfo(URI uri, HttpHeaders headers2, Mono<Principal> principal, @Nullable String protocol) {
        Assert.notNull((Object)uri, (String)"URI is required");
        Assert.notNull((Object)headers2, (String)"HttpHeaders are required");
        Assert.notNull(principal, (String)"Principal is required");
        this.uri = uri;
        this.headers = headers2;
        this.principalMono = principal;
        this.protocol = protocol;
    }

    public URI getUri() {
        return this.uri;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public Mono<Principal> getPrincipal() {
        return this.principalMono;
    }

    @Nullable
    public String getSubProtocol() {
        return this.protocol;
    }

    public String toString() {
        return "HandshakeInfo[uri=" + this.uri + ", headers=" + this.headers + "]";
    }
}

