/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec.xml;

import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.bind.MarshalException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.logging.Log;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.AbstractSingleValueEncoder;
import org.springframework.core.codec.CodecException;
import org.springframework.core.codec.EncodingException;
import org.springframework.core.codec.Hints;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.log.LogFormatUtils;
import org.springframework.http.codec.xml.JaxbContextContainer;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import reactor.core.publisher.Flux;

public class Jaxb2XmlEncoder
extends AbstractSingleValueEncoder<Object> {
    private final JaxbContextContainer jaxbContexts = new JaxbContextContainer();

    public Jaxb2XmlEncoder() {
        super(new MimeType[]{MimeTypeUtils.APPLICATION_XML, MimeTypeUtils.TEXT_XML});
    }

    public boolean canEncode(ResolvableType elementType, @Nullable MimeType mimeType) {
        if (super.canEncode(elementType, mimeType)) {
            Class outputClass = elementType.toClass();
            return outputClass.isAnnotationPresent(XmlRootElement.class) || outputClass.isAnnotationPresent(XmlType.class);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Flux<DataBuffer> encode(Object value, DataBufferFactory dataBufferFactory, ResolvableType type, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        if (!Hints.isLoggingSuppressed(hints)) {
            LogFormatUtils.traceDebug((Log)this.logger, traceOn -> {
                String formatted = LogFormatUtils.formatValue((Object)value, (traceOn == false ? 1 : 0) != 0);
                return Hints.getLogPrefix((Map)hints) + "Encoding [" + formatted + "]";
            });
        }
        boolean release = true;
        DataBuffer buffer = dataBufferFactory.allocateBuffer(1024);
        OutputStream outputStream = buffer.asOutputStream();
        Class clazz = ClassUtils.getUserClass((Object)value);
        try {
            Marshaller marshaller = this.jaxbContexts.createMarshaller(clazz);
            marshaller.setProperty("jaxb.encoding", (Object)StandardCharsets.UTF_8.name());
            marshaller.marshal(value, outputStream);
            release = false;
            Flux flux = Flux.just((Object)buffer);
            return flux;
        }
        catch (MarshalException ex) {
            Flux flux = Flux.error((Throwable)new EncodingException("Could not marshal " + value.getClass() + " to XML", (Throwable)ex));
            return flux;
        }
        catch (JAXBException ex) {
            Flux flux = Flux.error((Throwable)new CodecException("Invalid JAXB configuration", (Throwable)ex));
            return flux;
        }
        finally {
            if (release) {
                DataBufferUtils.release((DataBuffer)buffer);
            }
        }
    }
}

