/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.CookieImpl;
import io.undertow.util.HttpString;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.ResponseCookie;
import org.springframework.http.ZeroCopyHttpOutputMessage;
import org.springframework.http.server.reactive.AbstractListenerServerHttpResponse;
import org.springframework.http.server.reactive.AbstractListenerWriteFlushProcessor;
import org.springframework.http.server.reactive.AbstractListenerWriteProcessor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.xnio.channels.Channels;
import org.xnio.channels.StreamSinkChannel;
import reactor.core.publisher.Mono;

class UndertowServerHttpResponse
extends AbstractListenerServerHttpResponse
implements ZeroCopyHttpOutputMessage {
    private final HttpServerExchange exchange;
    @Nullable
    private StreamSinkChannel responseChannel;

    public UndertowServerHttpResponse(HttpServerExchange exchange2, DataBufferFactory bufferFactory) {
        super(bufferFactory);
        Assert.notNull((Object)exchange2, (String)"HttpServerExchange must not be null");
        this.exchange = exchange2;
    }

    @Override
    public <T> T getNativeResponse() {
        return (T)this.exchange;
    }

    @Override
    protected void applyStatusCode() {
        Integer statusCode = this.getStatusCodeValue();
        if (statusCode != null) {
            this.exchange.setStatusCode(statusCode.intValue());
        }
    }

    @Override
    protected void applyHeaders() {
        for (Map.Entry<String, List<String>> entry : this.getHeaders().entrySet()) {
            HttpString headerName = HttpString.tryFromString((String)entry.getKey());
            this.exchange.getResponseHeaders().addAll(headerName, (Collection)entry.getValue());
        }
    }

    @Override
    protected void applyCookies() {
        for (String name : this.getCookies().keySet()) {
            for (ResponseCookie httpCookie : (List)this.getCookies().get((Object)name)) {
                CookieImpl cookie = new CookieImpl(name, httpCookie.getValue());
                if (!httpCookie.getMaxAge().isNegative()) {
                    cookie.setMaxAge(Integer.valueOf((int)httpCookie.getMaxAge().getSeconds()));
                }
                if (httpCookie.getDomain() != null) {
                    cookie.setDomain(httpCookie.getDomain());
                }
                if (httpCookie.getPath() != null) {
                    cookie.setPath(httpCookie.getPath());
                }
                cookie.setSecure(httpCookie.isSecure());
                cookie.setHttpOnly(httpCookie.isHttpOnly());
                this.exchange.getResponseCookies().putIfAbsent(name, cookie);
            }
        }
    }

    @Override
    public Mono<Void> writeWith(File file, long position, long count) {
        return this.doCommit(() -> {
            AbstractInterruptibleChannel source = null;
            try {
                source = FileChannel.open(file.toPath(), StandardOpenOption.READ);
                StreamSinkChannel destination = this.exchange.getResponseChannel();
                Channels.transferBlocking((StreamSinkChannel)destination, (FileChannel)source, (long)position, (long)count);
                Mono mono = Mono.empty();
                return mono;
            }
            catch (IOException ex) {
                Mono mono = Mono.error((Throwable)ex);
                return mono;
            }
            finally {
                if (source != null) {
                    try {
                        source.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        });
    }

    @Override
    protected Processor<? super Publisher<? extends DataBuffer>, Void> createBodyFlushProcessor() {
        return new ResponseBodyFlushProcessor();
    }

    private ResponseBodyProcessor createBodyProcessor() {
        if (this.responseChannel == null) {
            this.responseChannel = this.exchange.getResponseChannel();
        }
        return new ResponseBodyProcessor(this.responseChannel);
    }

    private boolean isWritePossible() {
        if (this.responseChannel == null) {
            this.responseChannel = this.exchange.getResponseChannel();
        }
        if (!this.responseChannel.isWriteResumed()) {
            this.responseChannel.resumeWrites();
        }
        return this.responseChannel.isWriteResumed();
    }

    private class ResponseBodyFlushProcessor
    extends AbstractListenerWriteFlushProcessor<DataBuffer> {
        private ResponseBodyFlushProcessor() {
        }

        @Override
        protected Processor<? super DataBuffer, Void> createWriteProcessor() {
            return UndertowServerHttpResponse.this.createBodyProcessor();
        }

        @Override
        protected void flush() throws IOException {
            if (UndertowServerHttpResponse.this.responseChannel != null) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)"flush");
                }
                UndertowServerHttpResponse.this.responseChannel.flush();
            }
        }

        @Override
        protected void flushingFailed(Throwable t) {
            this.cancel();
            this.onError(t);
        }

        @Override
        protected boolean isWritePossible() {
            return UndertowServerHttpResponse.this.isWritePossible();
        }

        @Override
        protected boolean isFlushPending() {
            return false;
        }
    }

    private class ResponseBodyProcessor
    extends AbstractListenerWriteProcessor<DataBuffer> {
        private final StreamSinkChannel channel;
        @Nullable
        private volatile ByteBuffer byteBuffer;

        public ResponseBodyProcessor(StreamSinkChannel channel) {
            Assert.notNull((Object)channel, (String)"StreamSinkChannel must not be null");
            this.channel = channel;
            this.channel.getWriteSetter().set(c -> this.onWritePossible());
            this.channel.suspendWrites();
        }

        @Override
        protected boolean isWritePossible() {
            return UndertowServerHttpResponse.this.isWritePossible();
        }

        @Override
        protected boolean write(DataBuffer dataBuffer) throws IOException {
            ByteBuffer buffer = this.byteBuffer;
            if (buffer == null) {
                return false;
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("write: " + dataBuffer));
            }
            int total = buffer.remaining();
            int written = this.writeByteBuffer(buffer);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("written: " + written + " total: " + total));
            }
            if (written != total) {
                return false;
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("releaseData: " + dataBuffer));
            }
            DataBufferUtils.release((DataBuffer)dataBuffer);
            this.byteBuffer = null;
            return true;
        }

        private int writeByteBuffer(ByteBuffer byteBuffer) throws IOException {
            int written;
            int totalWritten = 0;
            do {
                written = this.channel.write(byteBuffer);
                totalWritten += written;
            } while (byteBuffer.hasRemaining() && written > 0);
            return totalWritten;
        }

        @Override
        protected void dataReceived(DataBuffer dataBuffer) {
            super.dataReceived(dataBuffer);
            this.byteBuffer = dataBuffer.asByteBuffer();
        }

        @Override
        protected boolean isDataEmpty(DataBuffer dataBuffer) {
            return dataBuffer.readableByteCount() == 0;
        }

        @Override
        protected void writingPaused() {
            this.channel.suspendWrites();
        }

        @Override
        protected void writingComplete() {
            this.channel.getWriteSetter().set(null);
            this.channel.resumeWrites();
        }

        @Override
        protected void writingFailed(Throwable ex) {
            this.cancel();
            this.onError(ex);
        }
    }
}

