/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.request;

import java.security.Principal;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.util.WebUtils;

public class ServletWebRequest
extends ServletRequestAttributes
implements NativeWebRequest {
    private static final String HEADER_ETAG = "ETag";
    private static final String HEADER_IF_MODIFIED_SINCE = "If-Modified-Since";
    private static final String HEADER_IF_NONE_MATCH = "If-None-Match";
    private static final String HEADER_LAST_MODIFIED = "Last-Modified";
    private static final String METHOD_GET = "GET";
    private static final String METHOD_HEAD = "HEAD";
    private static final boolean servlet3Present = ClassUtils.hasMethod(HttpServletResponse.class, (String)"getHeader", (Class[])new Class[]{String.class});
    private boolean notModified = false;

    public ServletWebRequest(HttpServletRequest request) {
        super(request);
    }

    public ServletWebRequest(HttpServletRequest request, HttpServletResponse response) {
        super(request, response);
    }

    @Override
    public Object getNativeRequest() {
        return this.getRequest();
    }

    @Override
    public Object getNativeResponse() {
        return this.getResponse();
    }

    @Override
    public <T> T getNativeRequest(Class<T> requiredType) {
        return WebUtils.getNativeRequest((ServletRequest)this.getRequest(), requiredType);
    }

    @Override
    public <T> T getNativeResponse(Class<T> requiredType) {
        return WebUtils.getNativeResponse((ServletResponse)this.getResponse(), requiredType);
    }

    public HttpMethod getHttpMethod() {
        return HttpMethod.valueOf(this.getRequest().getMethod());
    }

    @Override
    public String getHeader(String headerName) {
        return this.getRequest().getHeader(headerName);
    }

    @Override
    public String[] getHeaderValues(String headerName) {
        Object[] headerValues = StringUtils.toStringArray((Enumeration)this.getRequest().getHeaders(headerName));
        return !ObjectUtils.isEmpty((Object[])headerValues) ? headerValues : null;
    }

    @Override
    public Iterator<String> getHeaderNames() {
        return CollectionUtils.toIterator((Enumeration)this.getRequest().getHeaderNames());
    }

    @Override
    public String getParameter(String paramName) {
        return this.getRequest().getParameter(paramName);
    }

    @Override
    public String[] getParameterValues(String paramName) {
        return this.getRequest().getParameterValues(paramName);
    }

    @Override
    public Iterator<String> getParameterNames() {
        return CollectionUtils.toIterator((Enumeration)this.getRequest().getParameterNames());
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        return this.getRequest().getParameterMap();
    }

    @Override
    public Locale getLocale() {
        return this.getRequest().getLocale();
    }

    @Override
    public String getContextPath() {
        return this.getRequest().getContextPath();
    }

    @Override
    public String getRemoteUser() {
        return this.getRequest().getRemoteUser();
    }

    @Override
    public Principal getUserPrincipal() {
        return this.getRequest().getUserPrincipal();
    }

    @Override
    public boolean isUserInRole(String role) {
        return this.getRequest().isUserInRole(role);
    }

    @Override
    public boolean isSecure() {
        return this.getRequest().isSecure();
    }

    @Override
    public boolean checkNotModified(long lastModifiedTimestamp) {
        HttpServletResponse response = this.getResponse();
        if (lastModifiedTimestamp >= 0L && !this.notModified && this.isCompatibleWithConditionalRequests(response)) {
            this.notModified = this.isTimestampNotModified(lastModifiedTimestamp);
            if (response != null) {
                if (this.notModified && this.supportsNotModifiedStatus()) {
                    response.setStatus(304);
                }
                if (this.isHeaderAbsent(response, HEADER_LAST_MODIFIED)) {
                    response.setDateHeader(HEADER_LAST_MODIFIED, lastModifiedTimestamp);
                }
            }
        }
        return this.notModified;
    }

    @Override
    public boolean checkNotModified(String etag) {
        HttpServletResponse response = this.getResponse();
        if (StringUtils.hasLength((String)etag) && !this.notModified && this.isCompatibleWithConditionalRequests(response)) {
            etag = this.addEtagPadding(etag);
            this.notModified = this.isEtagNotModified(etag);
            if (response != null) {
                if (this.notModified && this.supportsNotModifiedStatus()) {
                    response.setStatus(304);
                }
                if (this.isHeaderAbsent(response, HEADER_ETAG)) {
                    response.setHeader(HEADER_ETAG, etag);
                }
            }
        }
        return this.notModified;
    }

    @Override
    public boolean checkNotModified(String etag, long lastModifiedTimestamp) {
        HttpServletResponse response = this.getResponse();
        if (StringUtils.hasLength((String)etag) && !this.notModified && this.isCompatibleWithConditionalRequests(response)) {
            boolean bl = this.notModified = this.isEtagNotModified(etag = this.addEtagPadding(etag)) && this.isTimestampNotModified(lastModifiedTimestamp);
            if (response != null) {
                if (this.notModified && this.supportsNotModifiedStatus()) {
                    response.setStatus(304);
                }
                if (this.isHeaderAbsent(response, HEADER_ETAG)) {
                    response.setHeader(HEADER_ETAG, etag);
                }
                if (this.isHeaderAbsent(response, HEADER_LAST_MODIFIED)) {
                    response.setDateHeader(HEADER_LAST_MODIFIED, lastModifiedTimestamp);
                }
            }
        }
        return this.notModified;
    }

    public boolean isNotModified() {
        return this.notModified;
    }

    private boolean isCompatibleWithConditionalRequests(HttpServletResponse response) {
        try {
            if (response == null || !servlet3Present) {
                return true;
            }
            return HttpStatus.valueOf(response.getStatus()).is2xxSuccessful();
        }
        catch (IllegalArgumentException e) {
            return true;
        }
    }

    private boolean isHeaderAbsent(HttpServletResponse response, String header) {
        if (response == null || !servlet3Present) {
            return true;
        }
        return response.getHeader(header) == null;
    }

    private boolean supportsNotModifiedStatus() {
        String method = this.getRequest().getMethod();
        return METHOD_GET.equals(method) || METHOD_HEAD.equals(method);
    }

    private boolean isTimestampNotModified(long lastModifiedTimestamp) {
        long ifModifiedSince;
        block4: {
            ifModifiedSince = -1L;
            try {
                ifModifiedSince = this.getRequest().getDateHeader(HEADER_IF_MODIFIED_SINCE);
            }
            catch (IllegalArgumentException ex) {
                String headerValue = this.getRequest().getHeader(HEADER_IF_MODIFIED_SINCE);
                int separatorIndex = headerValue.indexOf(59);
                if (separatorIndex == -1) break block4;
                String datePart = headerValue.substring(0, separatorIndex);
                try {
                    ifModifiedSince = Date.parse(datePart);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        return ifModifiedSince >= lastModifiedTimestamp / 1000L * 1000L;
    }

    private boolean isEtagNotModified(String etag) {
        String ifNoneMatch;
        if (StringUtils.hasLength((String)etag) && StringUtils.hasLength((String)(ifNoneMatch = this.getRequest().getHeader(HEADER_IF_NONE_MATCH)))) {
            String[] clientEtags;
            for (String clientEtag : clientEtags = StringUtils.delimitedListToStringArray((String)ifNoneMatch, (String)",", (String)" ")) {
                if (!StringUtils.hasLength((String)clientEtag) || !clientEtag.replaceFirst("^W/", "").equals(etag.replaceFirst("^W/", "")) && !clientEtag.equals("*")) continue;
                return true;
            }
        }
        return false;
    }

    private String addEtagPadding(String etag) {
        if (!etag.startsWith("\"") && !etag.startsWith("W/\"") || !etag.endsWith("\"")) {
            etag = "\"" + etag + "\"";
        }
        return etag;
    }

    @Override
    public String getDescription(boolean includeClientInfo) {
        HttpServletRequest request = this.getRequest();
        StringBuilder sb = new StringBuilder();
        sb.append("uri=").append(request.getRequestURI());
        if (includeClientInfo) {
            String user;
            HttpSession session;
            String client = request.getRemoteAddr();
            if (StringUtils.hasLength((String)client)) {
                sb.append(";client=").append(client);
            }
            if ((session = request.getSession(false)) != null) {
                sb.append(";session=").append(session.getId());
            }
            if (StringUtils.hasLength((String)(user = request.getRemoteUser()))) {
                sb.append(";user=").append(user);
            }
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return "ServletWebRequest: " + this.getDescription(true);
    }
}

