/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.util.Assert;

public class ServletServerHttpRequest
implements ServerHttpRequest {
    private final HttpServletRequest servletRequest;
    private HttpHeaders headers;

    public ServletServerHttpRequest(HttpServletRequest servletRequest) {
        Assert.notNull((Object)servletRequest, (String)"'servletRequest' must not be null");
        this.servletRequest = servletRequest;
    }

    public HttpMethod getMethod() {
        return HttpMethod.valueOf(this.servletRequest.getMethod());
    }

    public HttpHeaders getHeaders() {
        if (this.headers == null) {
            this.headers = new HttpHeaders();
            Enumeration headerNames = this.servletRequest.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                Enumeration headerValues = this.servletRequest.getHeaders(headerName);
                while (headerValues.hasMoreElements()) {
                    String headerValue = (String)headerValues.nextElement();
                    this.headers.add(headerName, headerValue);
                }
            }
        }
        return this.headers;
    }

    public InputStream getBody() throws IOException {
        return this.servletRequest.getInputStream();
    }
}

