/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.core.NamedThreadLocal;
import org.springframework.core.OrderComparator;
import org.springframework.transaction.support.ResourceHolder;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationUtils;
import org.springframework.util.Assert;

public abstract class TransactionSynchronizationManager {
    private static final ThreadLocal<Map<Object, Object>> resources = new NamedThreadLocal("Transactional resources");
    private static final ThreadLocal<Set<TransactionSynchronization>> synchronizations = new NamedThreadLocal("Transaction synchronizations");
    private static final ThreadLocal<String> currentTransactionName = new NamedThreadLocal("Current transaction name");
    private static final ThreadLocal<Boolean> currentTransactionReadOnly = new NamedThreadLocal("Current transaction read-only status");
    private static final ThreadLocal<Integer> currentTransactionIsolationLevel = new NamedThreadLocal("Current transaction isolation level");
    private static final ThreadLocal<Boolean> actualTransactionActive = new NamedThreadLocal("Actual transaction active");

    public static Map<Object, Object> getResourceMap() {
        Map<Object, Object> map = resources.get();
        return map != null ? Collections.unmodifiableMap(map) : Collections.emptyMap();
    }

    public static boolean hasResource(Object key) {
        Object actualKey = TransactionSynchronizationUtils.unwrapResourceIfNecessary(key);
        Object value = TransactionSynchronizationManager.doGetResource(actualKey);
        return value != null;
    }

    public static @Nullable Object getResource(Object key) {
        Object actualKey = TransactionSynchronizationUtils.unwrapResourceIfNecessary(key);
        return TransactionSynchronizationManager.doGetResource(actualKey);
    }

    private static @Nullable Object doGetResource(Object actualKey) {
        ResourceHolder resourceHolder;
        Map<Object, Object> map = resources.get();
        if (map == null) {
            return null;
        }
        Object value = map.get(actualKey);
        if (value instanceof ResourceHolder && (resourceHolder = (ResourceHolder)value).isVoid()) {
            map.remove(actualKey);
            if (map.isEmpty()) {
                resources.remove();
            }
            value = null;
        }
        return value;
    }

    public static void bindResource(Object key, Object value) throws IllegalStateException {
        Object actualKey = TransactionSynchronizationUtils.unwrapResourceIfNecessary(key);
        Object oldValue = TransactionSynchronizationManager.doBindResource(actualKey, value);
        if (oldValue != null) {
            throw new IllegalStateException("Already value [" + String.valueOf(oldValue) + "] for key [" + String.valueOf(actualKey) + "] bound to thread");
        }
    }

    public static void bindSynchronizedResource(Object key, final Object value) throws IllegalStateException {
        Set<TransactionSynchronization> synchs = synchronizations.get();
        if (synchs == null) {
            throw new IllegalStateException("Transaction synchronization is not active");
        }
        final Object actualKey = TransactionSynchronizationUtils.unwrapResourceIfNecessary(key);
        final Object oldValue = TransactionSynchronizationManager.doBindResource(actualKey, value);
        synchs.add(new TransactionSynchronization(){

            @Override
            public void suspend() {
                TransactionSynchronizationManager.doUnbindResource(actualKey);
            }

            @Override
            public void resume() {
                Object existingValue = TransactionSynchronizationManager.doBindResource(actualKey, value);
                if (existingValue != null) {
                    throw new IllegalStateException("Unexpected value [" + String.valueOf(existingValue) + "] for key [" + String.valueOf(actualKey) + "] bound on resume");
                }
            }

            @Override
            public void afterCompletion(int status) {
                TransactionSynchronizationManager.doUnbindResource(actualKey);
                if (oldValue != null) {
                    TransactionSynchronizationManager.doBindResource(actualKey, oldValue);
                }
            }
        });
    }

    private static @Nullable Object doBindResource(Object actualKey, Object value) {
        ResourceHolder resourceHolder;
        Object oldValue;
        Assert.notNull((Object)value, (String)"Value must not be null");
        Map<Object, Object> map = resources.get();
        if (map == null) {
            map = new HashMap<Object, Object>();
            resources.set(map);
        }
        if ((oldValue = map.put(actualKey, value)) instanceof ResourceHolder && (resourceHolder = (ResourceHolder)oldValue).isVoid()) {
            oldValue = null;
        }
        return oldValue;
    }

    public static Object unbindResource(Object key) throws IllegalStateException {
        Object actualKey = TransactionSynchronizationUtils.unwrapResourceIfNecessary(key);
        Object value = TransactionSynchronizationManager.doUnbindResource(actualKey);
        if (value == null) {
            throw new IllegalStateException("No value for key [" + String.valueOf(actualKey) + "] bound to thread");
        }
        return value;
    }

    public static @Nullable Object unbindResourceIfPossible(Object key) {
        Object actualKey = TransactionSynchronizationUtils.unwrapResourceIfNecessary(key);
        return TransactionSynchronizationManager.doUnbindResource(actualKey);
    }

    private static @Nullable Object doUnbindResource(Object actualKey) {
        ResourceHolder resourceHolder;
        Map<Object, Object> map = resources.get();
        if (map == null) {
            return null;
        }
        Object value = map.remove(actualKey);
        if (map.isEmpty()) {
            resources.remove();
        }
        if (value instanceof ResourceHolder && (resourceHolder = (ResourceHolder)value).isVoid()) {
            value = null;
        }
        return value;
    }

    public static boolean isSynchronizationActive() {
        return synchronizations.get() != null;
    }

    public static void initSynchronization() throws IllegalStateException {
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            throw new IllegalStateException("Cannot activate transaction synchronization - already active");
        }
        synchronizations.set(new LinkedHashSet());
    }

    public static void registerSynchronization(TransactionSynchronization synchronization) throws IllegalStateException {
        Assert.notNull((Object)synchronization, (String)"TransactionSynchronization must not be null");
        Set<TransactionSynchronization> synchs = synchronizations.get();
        if (synchs == null) {
            throw new IllegalStateException("Transaction synchronization is not active");
        }
        synchs.add(synchronization);
    }

    public static List<TransactionSynchronization> getSynchronizations() throws IllegalStateException {
        Set<TransactionSynchronization> synchs = synchronizations.get();
        if (synchs == null) {
            throw new IllegalStateException("Transaction synchronization is not active");
        }
        if (synchs.isEmpty()) {
            return Collections.emptyList();
        }
        if (synchs.size() == 1) {
            return Collections.singletonList(synchs.iterator().next());
        }
        ArrayList<TransactionSynchronization> sortedSynchs = new ArrayList<TransactionSynchronization>(synchs);
        OrderComparator.sort(sortedSynchs);
        return Collections.unmodifiableList(sortedSynchs);
    }

    public static void clearSynchronization() throws IllegalStateException {
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            throw new IllegalStateException("Cannot deactivate transaction synchronization - not active");
        }
        synchronizations.remove();
    }

    public static void setCurrentTransactionName(@Nullable String name) {
        currentTransactionName.set(name);
    }

    public static @Nullable String getCurrentTransactionName() {
        return currentTransactionName.get();
    }

    public static void setCurrentTransactionReadOnly(boolean readOnly) {
        currentTransactionReadOnly.set(readOnly ? Boolean.TRUE : null);
    }

    public static boolean isCurrentTransactionReadOnly() {
        return currentTransactionReadOnly.get() != null;
    }

    public static void setCurrentTransactionIsolationLevel(@Nullable Integer isolationLevel) {
        currentTransactionIsolationLevel.set(isolationLevel);
    }

    public static @Nullable Integer getCurrentTransactionIsolationLevel() {
        return currentTransactionIsolationLevel.get();
    }

    public static void setActualTransactionActive(boolean active) {
        actualTransactionActive.set(active ? Boolean.TRUE : null);
    }

    public static boolean isActualTransactionActive() {
        return actualTransactionActive.get() != null;
    }

    public static void clear() {
        synchronizations.remove();
        currentTransactionName.remove();
        currentTransactionReadOnly.remove();
        currentTransactionIsolationLevel.remove();
        actualTransactionActive.remove();
    }
}

