/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.OrderComparator;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.util.Assert;

public abstract class TransactionSynchronizationManager {
    private static final Log logger = LogFactory.getLog((Class)TransactionSynchronizationManager.class);
    private static final ThreadLocal resources = new ThreadLocal();
    private static final ThreadLocal synchronizations = new ThreadLocal();
    private static final Comparator synchronizationComparator = new OrderComparator();
    private static final ThreadLocal currentTransactionName = new ThreadLocal();
    private static final ThreadLocal currentTransactionReadOnly = new ThreadLocal();
    private static final ThreadLocal currentTransactionIsolationLevel = new ThreadLocal();
    private static final ThreadLocal actualTransactionActive = new ThreadLocal();

    public static Map getResourceMap() {
        Map map = (Map)resources.get();
        return map != null ? Collections.unmodifiableMap(map) : Collections.EMPTY_MAP;
    }

    public static boolean hasResource(Object key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Map map = (Map)resources.get();
        return map != null && map.containsKey(key);
    }

    public static Object getResource(Object key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Map map = (Map)resources.get();
        if (map == null) {
            return null;
        }
        Object value = map.get(key);
        if (value != null && logger.isDebugEnabled()) {
            logger.debug((Object)("Retrieved value [" + value + "] for key [" + key + "] bound to thread [" + Thread.currentThread().getName() + "]"));
        }
        return value;
    }

    public static void bindResource(Object key, Object value) throws IllegalStateException {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        HashMap<Object, Object> map = (HashMap<Object, Object>)resources.get();
        if (map == null) {
            map = new HashMap<Object, Object>();
            resources.set(map);
        }
        if (map.containsKey(key)) {
            throw new IllegalStateException("Already value [" + map.get(key) + "] for key [" + key + "] bound to thread [" + Thread.currentThread().getName() + "]");
        }
        map.put(key, value);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Bound value [" + value + "] for key [" + key + "] to thread [" + Thread.currentThread().getName() + "]"));
        }
    }

    public static Object unbindResource(Object key) throws IllegalStateException {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Map map = (Map)resources.get();
        if (map == null || !map.containsKey(key)) {
            throw new IllegalStateException("No value for key [" + key + "] bound to thread [" + Thread.currentThread().getName() + "]");
        }
        Object value = map.remove(key);
        if (map.isEmpty()) {
            resources.set(null);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Removed value [" + value + "] for key [" + key + "] from thread [" + Thread.currentThread().getName() + "]"));
        }
        return value;
    }

    public static boolean isSynchronizationActive() {
        return synchronizations.get() != null;
    }

    public static void initSynchronization() throws IllegalStateException {
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            throw new IllegalStateException("Cannot activate transaction synchronization - already active");
        }
        logger.debug((Object)"Initializing transaction synchronization");
        synchronizations.set(new LinkedList());
    }

    public static void registerSynchronization(TransactionSynchronization synchronization) throws IllegalStateException {
        Assert.notNull((Object)synchronization, (String)"TransactionSynchronization must not be null");
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            throw new IllegalStateException("Transaction synchronization is not active");
        }
        List synchs = (List)synchronizations.get();
        synchs.add(synchronization);
    }

    public static List getSynchronizations() throws IllegalStateException {
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            throw new IllegalStateException("Transaction synchronization is not active");
        }
        List synchs = (List)synchronizations.get();
        Collections.sort(synchs, synchronizationComparator);
        return Collections.unmodifiableList(new ArrayList(synchs));
    }

    public static void clearSynchronization() throws IllegalStateException {
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            throw new IllegalStateException("Cannot deactivate transaction synchronization - not active");
        }
        logger.debug((Object)"Clearing transaction synchronization");
        synchronizations.set(null);
    }

    public static void setCurrentTransactionName(String name) {
        currentTransactionName.set(name);
    }

    public static String getCurrentTransactionName() {
        return (String)currentTransactionName.get();
    }

    public static void setCurrentTransactionReadOnly(boolean readOnly) {
        currentTransactionReadOnly.set(readOnly ? Boolean.TRUE : null);
    }

    public static boolean isCurrentTransactionReadOnly() {
        return currentTransactionReadOnly.get() != null;
    }

    public static void setCurrentTransactionIsolationLevel(Integer isolationLevel) {
        currentTransactionIsolationLevel.set(isolationLevel);
    }

    public static Integer getCurrentTransactionIsolationLevel() {
        return (Integer)currentTransactionIsolationLevel.get();
    }

    public static void setActualTransactionActive(boolean active) {
        actualTransactionActive.set(active ? Boolean.TRUE : null);
    }

    public static boolean isActualTransactionActive() {
        return actualTransactionActive.get() != null;
    }

    public static void clear() {
        TransactionSynchronizationManager.clearSynchronization();
        TransactionSynchronizationManager.setCurrentTransactionName(null);
        TransactionSynchronizationManager.setCurrentTransactionReadOnly(false);
        TransactionSynchronizationManager.setCurrentTransactionIsolationLevel(null);
        TransactionSynchronizationManager.setActualTransactionActive(false);
    }
}

