/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.testng;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.test.context.TestContextManager;
import org.testng.IHookCallBack;
import org.testng.IHookable;
import org.testng.ITestResult;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;

public abstract class AbstractTestNGSpringContextTests
implements IHookable,
ApplicationContextAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected @Nullable ApplicationContext applicationContext;
    private final TestContextManager testContextManager;
    private final ThreadLocal<@Nullable Throwable> testException = new ThreadLocal();

    public AbstractTestNGSpringContextTests() {
        this.testContextManager = new TestContextManager(this.getClass());
    }

    public final void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @BeforeClass(alwaysRun=true)
    protected void springTestContextBeforeTestClass() throws Exception {
        this.testContextManager.beforeTestClass();
    }

    @BeforeClass(alwaysRun=true, dependsOnMethods={"springTestContextBeforeTestClass"})
    protected void springTestContextPrepareTestInstance() throws Exception {
        this.testContextManager.prepareTestInstance(this);
    }

    @BeforeMethod(alwaysRun=true)
    protected void springTestContextBeforeTestMethod(Method testMethod) throws Exception {
        this.testContextManager.beforeTestMethod(this, testMethod);
    }

    public void run(IHookCallBack callBack, ITestResult testResult) {
        Throwable currentException;
        block6: {
            Method testMethod = testResult.getMethod().getConstructorOrMethod().getMethod();
            boolean beforeCallbacksExecuted = false;
            currentException = null;
            try {
                this.testContextManager.beforeTestExecution(this, testMethod);
                beforeCallbacksExecuted = true;
            }
            catch (Throwable ex) {
                currentException = ex;
            }
            if (beforeCallbacksExecuted) {
                callBack.runTestMethod(testResult);
                currentException = this.getTestResultException(testResult);
            }
            try {
                this.testContextManager.afterTestExecution(this, testMethod, currentException);
            }
            catch (Throwable ex) {
                if (currentException != null) break block6;
                currentException = ex;
            }
        }
        if (currentException != null) {
            this.testException.set(currentException);
            this.throwAsUncheckedException(currentException);
        }
    }

    @AfterMethod(alwaysRun=true)
    protected void springTestContextAfterTestMethod(Method testMethod) throws Exception {
        try {
            this.testContextManager.afterTestMethod(this, testMethod, this.testException.get());
        }
        finally {
            this.testException.remove();
        }
    }

    @AfterClass(alwaysRun=true)
    protected void springTestContextAfterTestClass() throws Exception {
        this.testContextManager.afterTestClass();
    }

    private @Nullable Throwable getTestResultException(ITestResult testResult) {
        Throwable testResultException = testResult.getThrowable();
        if (testResultException instanceof InvocationTargetException) {
            testResultException = testResultException.getCause();
        }
        return testResultException;
    }

    private RuntimeException throwAsUncheckedException(Throwable t) {
        this.throwAs(t);
        throw new IllegalStateException(t);
    }

    private <T extends Throwable> void throwAs(Throwable t) throws T {
        throw t;
    }
}

