/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.http.client;

import java.io.IOException;
import java.net.URI;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.mock.http.MockHttpOutputMessage;

public class MockClientHttpRequest
extends MockHttpOutputMessage
implements ClientHttpRequest {
    private URI uri;
    private HttpMethod httpMethod;
    private boolean executed = false;
    private ClientHttpResponse clientHttpResponse;

    public MockClientHttpRequest() {
    }

    public MockClientHttpRequest(HttpMethod httpMethod, URI uri) {
        this.httpMethod = httpMethod;
        this.uri = uri;
    }

    public URI getURI() {
        return this.uri;
    }

    public void setURI(URI uri) {
        this.uri = uri;
    }

    public HttpMethod getMethod() {
        return this.httpMethod;
    }

    public void setMethod(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
    }

    public void setResponse(ClientHttpResponse clientHttpResponse) {
        this.clientHttpResponse = clientHttpResponse;
    }

    public boolean isExecuted() {
        return this.executed;
    }

    public final ClientHttpResponse execute() throws IOException {
        this.executed = true;
        return this.executeInternal();
    }

    protected ClientHttpResponse executeInternal() throws IOException {
        return this.clientHttpResponse;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.httpMethod != null) {
            sb.append(this.httpMethod);
        }
        if (this.uri != null) {
            sb.append(" ").append(this.uri);
        }
        if (!this.getHeaders().isEmpty()) {
            sb.append(", headers : ").append(this.getHeaders());
        }
        if (sb.length() == 0) {
            sb.append("Not yet initialized");
        }
        return sb.toString();
    }
}

