/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.test.context.ContextCache;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestExecutionListener;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestContextManager {
    private static final String[] DEFAULT_TEST_EXECUTION_LISTENER_CLASS_NAMES = new String[]{"org.springframework.test.context.support.DependencyInjectionTestExecutionListener", "org.springframework.test.context.support.DirtiesContextTestExecutionListener", "org.springframework.test.context.transaction.TransactionalTestExecutionListener"};
    private static final Log logger = LogFactory.getLog(TestContextManager.class);
    static final ContextCache contextCache = new ContextCache();
    private final TestContext testContext;
    private final List<TestExecutionListener> testExecutionListeners = new ArrayList<TestExecutionListener>();

    public TestContextManager(Class<?> testClass) {
        this(testClass, null);
    }

    public TestContextManager(Class<?> testClass, String defaultContextLoaderClassName) {
        this.testContext = new TestContext(testClass, contextCache, defaultContextLoaderClassName);
        this.registerTestExecutionListeners(this.retrieveTestExecutionListeners(testClass));
    }

    protected final TestContext getTestContext() {
        return this.testContext;
    }

    public void registerTestExecutionListeners(TestExecutionListener ... testExecutionListeners) {
        TestExecutionListener[] testExecutionListenerArray = testExecutionListeners;
        int n = testExecutionListeners.length;
        int n2 = 0;
        while (n2 < n) {
            TestExecutionListener listener = testExecutionListenerArray[n2];
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Registering TestExecutionListener: " + listener));
            }
            this.testExecutionListeners.add(listener);
            ++n2;
        }
    }

    public final List<TestExecutionListener> getTestExecutionListeners() {
        return this.testExecutionListeners;
    }

    private List<TestExecutionListener> getReversedTestExecutionListeners() {
        ArrayList<TestExecutionListener> listenersReversed = new ArrayList<TestExecutionListener>(this.getTestExecutionListeners());
        Collections.reverse(listenersReversed);
        return listenersReversed;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private TestExecutionListener[] retrieveTestExecutionListeners(Class<?> clazz) {
        block10: {
            Assert.notNull(clazz, (String)"Class must not be null");
            annotationType = TestExecutionListeners.class;
            classesList = new ArrayList<Class<? extends TestExecutionListener>>();
            declaringClass = AnnotationUtils.findAnnotationDeclaringClass(annotationType, clazz);
            defaultListeners = false;
            if (declaringClass != null) ** GOTO lbl28
            if (TestContextManager.logger.isInfoEnabled()) {
                TestContextManager.logger.info((Object)("@TestExecutionListeners is not present for class [" + clazz + "]: using defaults."));
            }
            classesList.addAll(this.getDefaultTestExecutionListenerClasses());
            defaultListeners = true;
            break block10;
lbl-1000:
            // 1 sources

            {
                testExecutionListeners = declaringClass.getAnnotation(annotationType);
                if (TestContextManager.logger.isTraceEnabled()) {
                    TestContextManager.logger.trace((Object)("Retrieved @TestExecutionListeners [" + testExecutionListeners + "] for declaring class [" + declaringClass + "]."));
                }
                valueListenerClasses = testExecutionListeners.value();
                listenerClasses = testExecutionListeners.listeners();
                if (!ObjectUtils.isEmpty((Object[])valueListenerClasses) && !ObjectUtils.isEmpty((Object[])listenerClasses)) {
                    msg = String.format("Test class [%s] has been configured with @TestExecutionListeners' 'value' [%s] and 'listeners' [%s] attributes. Use one or the other, but not both.", new Object[]{declaringClass, ObjectUtils.nullSafeToString((Object[])valueListenerClasses), ObjectUtils.nullSafeToString((Object[])listenerClasses)});
                    TestContextManager.logger.error((Object)msg);
                    throw new IllegalStateException(msg);
                }
                if (!ObjectUtils.isEmpty((Object[])valueListenerClasses)) {
                    listenerClasses = valueListenerClasses;
                }
                if (listenerClasses != null) {
                    classesList.addAll(0, (Collection)Arrays.asList(listenerClasses));
                }
                v0 = declaringClass = testExecutionListeners.inheritListeners() != false ? AnnotationUtils.findAnnotationDeclaringClass(annotationType, declaringClass.getSuperclass()) : null;
lbl28:
                // 2 sources

                ** while (declaringClass != null)
            }
        }
        listeners = new ArrayList<TestExecutionListener>(classesList.size());
        for (Class listenerClass : classesList) {
            try {
                listeners.add((TestExecutionListener)BeanUtils.instantiateClass((Class)listenerClass));
            }
            catch (NoClassDefFoundError err) {
                if (defaultListeners) {
                    if (!TestContextManager.logger.isDebugEnabled()) continue;
                    TestContextManager.logger.debug((Object)("Could not instantiate default TestExecutionListener class [" + listenerClass.getName() + "]. Specify custom listener classes or make the default listener classes available."));
                    continue;
                }
                throw err;
            }
        }
        return listeners.toArray(new TestExecutionListener[listeners.size()]);
    }

    protected Set<Class<? extends TestExecutionListener>> getDefaultTestExecutionListenerClasses() {
        LinkedHashSet<Class<? extends TestExecutionListener>> defaultListenerClasses = new LinkedHashSet<Class<? extends TestExecutionListener>>();
        String[] stringArray = DEFAULT_TEST_EXECUTION_LISTENER_CLASS_NAMES;
        int n = DEFAULT_TEST_EXECUTION_LISTENER_CLASS_NAMES.length;
        int n2 = 0;
        while (n2 < n) {
            block3: {
                String className = stringArray[n2];
                try {
                    defaultListenerClasses.add(this.getClass().getClassLoader().loadClass(className));
                }
                catch (Throwable throwable) {
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug((Object)("Could not load default TestExecutionListener class [" + className + "]. Specify custom listener classes or make the default listener classes available."));
                }
            }
            ++n2;
        }
        return defaultListenerClasses;
    }

    public void beforeTestClass() throws Exception {
        Class<?> testClass = this.getTestContext().getTestClass();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("beforeTestClass(): class [" + testClass + "]"));
        }
        this.getTestContext().updateState(null, null, null);
        for (TestExecutionListener testExecutionListener : this.getTestExecutionListeners()) {
            try {
                testExecutionListener.beforeTestClass(this.getTestContext());
            }
            catch (Exception ex) {
                logger.warn((Object)("Caught exception while allowing TestExecutionListener [" + testExecutionListener + "] to process 'before class' callback for test class [" + testClass + "]"), (Throwable)ex);
                throw ex;
            }
        }
    }

    public void prepareTestInstance(Object testInstance) throws Exception {
        Assert.notNull((Object)testInstance, (String)"testInstance must not be null");
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("prepareTestInstance(): instance [" + testInstance + "]"));
        }
        this.getTestContext().updateState(testInstance, null, null);
        for (TestExecutionListener testExecutionListener : this.getTestExecutionListeners()) {
            try {
                testExecutionListener.prepareTestInstance(this.getTestContext());
            }
            catch (Exception ex) {
                logger.error((Object)("Caught exception while allowing TestExecutionListener [" + testExecutionListener + "] to prepare test instance [" + testInstance + "]"), (Throwable)ex);
                throw ex;
            }
        }
    }

    public void beforeTestMethod(Object testInstance, Method testMethod) throws Exception {
        Assert.notNull((Object)testInstance, (String)"Test instance must not be null");
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("beforeTestMethod(): instance [" + testInstance + "], method [" + testMethod + "]"));
        }
        this.getTestContext().updateState(testInstance, testMethod, null);
        for (TestExecutionListener testExecutionListener : this.getTestExecutionListeners()) {
            try {
                testExecutionListener.beforeTestMethod(this.getTestContext());
            }
            catch (Exception ex) {
                logger.warn((Object)("Caught exception while allowing TestExecutionListener [" + testExecutionListener + "] to process 'before' execution of test method [" + testMethod + "] for test instance [" + testInstance + "]"), (Throwable)ex);
                throw ex;
            }
        }
    }

    public void afterTestMethod(Object testInstance, Method testMethod, Throwable exception) throws Exception {
        Assert.notNull((Object)testInstance, (String)"testInstance must not be null");
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("afterTestMethod(): instance [" + testInstance + "], method [" + testMethod + "], exception [" + exception + "]"));
        }
        this.getTestContext().updateState(testInstance, testMethod, exception);
        Exception afterTestMethodException = null;
        for (TestExecutionListener testExecutionListener : this.getReversedTestExecutionListeners()) {
            try {
                testExecutionListener.afterTestMethod(this.getTestContext());
            }
            catch (Exception ex) {
                logger.warn((Object)("Caught exception while allowing TestExecutionListener [" + testExecutionListener + "] to process 'after' execution for test: method [" + testMethod + "], instance [" + testInstance + "], exception [" + exception + "]"), (Throwable)ex);
                if (afterTestMethodException != null) continue;
                afterTestMethodException = ex;
            }
        }
        if (afterTestMethodException != null) {
            throw afterTestMethodException;
        }
    }

    public void afterTestClass() throws Exception {
        Class<?> testClass = this.getTestContext().getTestClass();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("afterTestClass(): class [" + testClass + "]"));
        }
        this.getTestContext().updateState(null, null, null);
        Exception afterTestClassException = null;
        for (TestExecutionListener testExecutionListener : this.getReversedTestExecutionListeners()) {
            try {
                testExecutionListener.afterTestClass(this.getTestContext());
            }
            catch (Exception ex) {
                logger.warn((Object)("Caught exception while allowing TestExecutionListener [" + testExecutionListener + "] to process 'after class' callback for test class [" + testClass + "]"), (Throwable)ex);
                if (afterTestClassException != null) continue;
                afterTestClassException = ex;
            }
        }
        if (afterTestClassException != null) {
            throw afterTestClassException;
        }
    }
}

