/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa.hibernate;

import jakarta.persistence.EntityManager;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.StatelessSession;
import org.hibernate.Transaction;
import org.jspecify.annotations.Nullable;
import org.springframework.orm.jpa.EntityManagerHolder;
import org.springframework.util.Assert;

public class SessionHolder
extends EntityManagerHolder {
    private @Nullable StatelessSession statelessSession;
    private @Nullable Transaction transaction;
    private @Nullable FlushMode previousFlushMode;

    public SessionHolder(Session session) {
        super((EntityManager)session);
    }

    SessionHolder(StatelessSession session) {
        super(null);
        this.statelessSession = session;
    }

    void setSession(Session session) {
        this.entityManager = session;
    }

    public Session getSession() {
        return (Session)this.getEntityManager();
    }

    boolean hasSession() {
        return this.entityManager != null;
    }

    void setStatelessSession(StatelessSession statelessSession) {
        this.statelessSession = statelessSession;
    }

    StatelessSession getStatelessSession() {
        Assert.state((this.statelessSession != null ? 1 : 0) != 0, (String)"No StatelessSession available");
        return this.statelessSession;
    }

    boolean hasStatelessSession() {
        return this.statelessSession != null;
    }

    void setTransaction(@Nullable Transaction transaction) {
        this.transaction = transaction;
        this.setTransactionActive(transaction != null);
    }

    @Nullable Transaction getTransaction() {
        return this.transaction;
    }

    void setPreviousFlushMode(@Nullable FlushMode previousFlushMode) {
        this.previousFlushMode = previousFlushMode;
    }

    @Nullable FlushMode getPreviousFlushMode() {
        return this.previousFlushMode;
    }

    @Override
    public void clear() {
        super.clear();
        this.transaction = null;
        this.previousFlushMode = null;
    }

    @Override
    protected void closeAll() {
        super.closeAll();
        if (this.statelessSession != null && this.statelessSession.isOpen()) {
            this.statelessSession.close();
        }
    }
}

