/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.handler.invocation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.MethodParameter;
import org.springframework.messaging.Message;
import org.springframework.messaging.handler.invocation.AsyncHandlerMethodReturnValueHandler;
import org.springframework.messaging.handler.invocation.HandlerMethodReturnValueHandler;
import org.springframework.util.Assert;
import org.springframework.util.concurrent.ListenableFuture;

public class HandlerMethodReturnValueHandlerComposite
implements AsyncHandlerMethodReturnValueHandler {
    private static final Log logger = LogFactory.getLog(HandlerMethodReturnValueHandlerComposite.class);
    private final List<HandlerMethodReturnValueHandler> returnValueHandlers = new ArrayList<HandlerMethodReturnValueHandler>();

    public List<HandlerMethodReturnValueHandler> getReturnValueHandlers() {
        return Collections.unmodifiableList(this.returnValueHandlers);
    }

    public void clear() {
        this.returnValueHandlers.clear();
    }

    public HandlerMethodReturnValueHandlerComposite addHandler(HandlerMethodReturnValueHandler returnValuehandler) {
        this.returnValueHandlers.add(returnValuehandler);
        return this;
    }

    public HandlerMethodReturnValueHandlerComposite addHandlers(List<? extends HandlerMethodReturnValueHandler> handlers) {
        if (handlers != null) {
            for (HandlerMethodReturnValueHandler handlerMethodReturnValueHandler : handlers) {
                this.returnValueHandlers.add(handlerMethodReturnValueHandler);
            }
        }
        return this;
    }

    @Override
    public boolean supportsReturnType(MethodParameter returnType) {
        return this.getReturnValueHandler(returnType) != null;
    }

    private HandlerMethodReturnValueHandler getReturnValueHandler(MethodParameter returnType) {
        for (HandlerMethodReturnValueHandler handler : this.returnValueHandlers) {
            if (!handler.supportsReturnType(returnType)) continue;
            return handler;
        }
        return null;
    }

    @Override
    public void handleReturnValue(Object returnValue, MethodParameter returnType, Message<?> message) throws Exception {
        HandlerMethodReturnValueHandler handler = this.getReturnValueHandler(returnType);
        if (handler == null) {
            throw new IllegalStateException("No handler for return value type: " + returnType.getParameterType());
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Processing return value with " + handler));
        }
        handler.handleReturnValue(returnValue, returnType, message);
    }

    @Override
    public boolean isAsyncReturnValue(Object returnValue, MethodParameter returnType) {
        HandlerMethodReturnValueHandler handler = this.getReturnValueHandler(returnType);
        return handler instanceof AsyncHandlerMethodReturnValueHandler && ((AsyncHandlerMethodReturnValueHandler)handler).isAsyncReturnValue(returnValue, returnType);
    }

    @Override
    public ListenableFuture<?> toListenableFuture(Object returnValue, MethodParameter returnType) {
        HandlerMethodReturnValueHandler handler = this.getReturnValueHandler(returnType);
        Assert.state((boolean)(handler instanceof AsyncHandlerMethodReturnValueHandler), (String)"AsyncHandlerMethodReturnValueHandler required");
        return ((AsyncHandlerMethodReturnValueHandler)handler).toListenableFuture(returnValue, returnType);
    }
}

