/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.support;

import java.util.concurrent.Executor;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.support.AbstractSubscribableChannel;

public class ExecutorSubscribableChannel
extends AbstractSubscribableChannel {
    private final Executor executor;

    public ExecutorSubscribableChannel() {
        this(null);
    }

    public ExecutorSubscribableChannel(Executor executor) {
        this.executor = executor;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public boolean sendInternal(final Message<?> message, long timeout) {
        for (final MessageHandler handler : this.getSubscribers()) {
            if (this.executor == null) {
                handler.handleMessage(message);
                continue;
            }
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    handler.handleMessage(message);
                }
            });
        }
        return true;
    }
}

