/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms;

import jakarta.jms.JMSException;
import org.springframework.core.NestedRuntimeException;
import org.springframework.lang.Nullable;

public abstract class JmsException
extends NestedRuntimeException {
    public JmsException(String msg) {
        super(msg);
    }

    public JmsException(String msg, @Nullable Throwable cause) {
        super(msg, cause);
    }

    public JmsException(@Nullable Throwable cause) {
        super(cause != null ? cause.getMessage() : null, cause);
    }

    @Nullable
    public String getErrorCode() {
        Throwable cause = this.getCause();
        if (cause instanceof JMSException) {
            JMSException jmsException = (JMSException)cause;
            return jmsException.getErrorCode();
        }
        return null;
    }

    @Nullable
    public String getMessage() {
        JMSException jmsException;
        Exception linkedEx;
        Object message = super.getMessage();
        Throwable cause = this.getCause();
        if (cause instanceof JMSException && (linkedEx = (jmsException = (JMSException)cause).getLinkedException()) != null) {
            String linkedMessage = linkedEx.getMessage();
            String causeMessage = cause.getMessage();
            if (!(linkedMessage == null || causeMessage != null && causeMessage.contains(linkedMessage))) {
                message = (String)message + "; nested exception is " + String.valueOf(linkedEx);
            }
        }
        return message;
    }
}

