/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core.namedparam;

import java.util.HashMap;
import java.util.Map;
import org.springframework.jdbc.core.SqlParameterValue;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.lang.Nullable;

public class SqlParameterSourceUtils {
    public static SqlParameterSource[] createBatch(Map<String, ?>[] valueMaps) {
        SqlParameterSource[] batch = new MapSqlParameterSource[valueMaps.length];
        for (int i = 0; i < valueMaps.length; ++i) {
            Map<String, ?> valueMap = valueMaps[i];
            batch[i] = new MapSqlParameterSource(valueMap);
        }
        return batch;
    }

    public static SqlParameterSource[] createBatch(Object[] beans) {
        SqlParameterSource[] batch = new BeanPropertySqlParameterSource[beans.length];
        for (int i = 0; i < beans.length; ++i) {
            Object bean = beans[i];
            batch[i] = new BeanPropertySqlParameterSource(bean);
        }
        return batch;
    }

    @Nullable
    public static Object getTypedValue(SqlParameterSource source, String parameterName) {
        int sqlType = source.getSqlType(parameterName);
        if (sqlType != Integer.MIN_VALUE) {
            if (source.getTypeName(parameterName) != null) {
                return new SqlParameterValue(sqlType, source.getTypeName(parameterName), source.getValue(parameterName));
            }
            return new SqlParameterValue(sqlType, source.getValue(parameterName));
        }
        return source.getValue(parameterName);
    }

    public static Map<String, String> extractCaseInsensitiveParameterNames(SqlParameterSource parameterSource) {
        HashMap<String, String> caseInsensitiveParameterNames;
        block3: {
            block2: {
                String[] propertyNames;
                caseInsensitiveParameterNames = new HashMap<String, String>();
                if (!(parameterSource instanceof BeanPropertySqlParameterSource)) break block2;
                for (String name : propertyNames = ((BeanPropertySqlParameterSource)parameterSource).getReadablePropertyNames()) {
                    caseInsensitiveParameterNames.put(name.toLowerCase(), name);
                }
                break block3;
            }
            if (!(parameterSource instanceof MapSqlParameterSource)) break block3;
            for (String name : ((MapSqlParameterSource)parameterSource).getValues().keySet()) {
                caseInsensitiveParameterNames.put(name.toLowerCase(), name);
            }
        }
        return caseInsensitiveParameterNames;
    }
}

