/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.twitter.api.impl;

import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.social.twitter.api.Stream;
import org.springframework.social.twitter.api.StreamingException;
import org.springframework.social.twitter.api.impl.StreamCreationException;
import org.springframework.social.twitter.api.impl.StreamReader;

abstract class ThreadedStreamConsumer
extends Thread
implements Stream {
    private AtomicBoolean open = new AtomicBoolean(true);
    private StreamReader streamReader;
    static final long HTTP_ERROR_SLEEP_MAX = 320000L;
    static final long NETWORK_ERROR_SLEEP_MAX = 16000L;
    private static final long MIN_WAIT = 250L;

    public void run() {
        long timeToSleep = 250L;
        this.streamReader = null;
        while (this.open.get()) {
            try {
                if (this.streamReader == null) {
                    this.streamReader = this.getStreamReader();
                    timeToSleep = 250L;
                }
                this.streamReader.next();
            }
            catch (StreamingException e) {
                this.streamReader = null;
            }
            catch (StreamCreationException e) {
                if (e.getHttpStatus() != null) {
                    if (timeToSleep == 250L) {
                        timeToSleep = 5000L;
                    }
                    this.sleepBeforeRetry(timeToSleep);
                    if ((timeToSleep *= 2L) <= 320000L) continue;
                    this.close();
                    continue;
                }
                if (!this.open.get()) continue;
                if (timeToSleep == 250L) {
                    timeToSleep = 250L;
                }
                this.sleepBeforeRetry(timeToSleep);
                timeToSleep = Math.min(timeToSleep + 250L, 16000L);
            }
        }
    }

    public void open() {
        this.start();
    }

    public void close() {
        this.open.set(false);
        if (this.streamReader != null) {
            this.streamReader.close();
        }
    }

    protected abstract StreamReader getStreamReader() throws StreamCreationException;

    protected void sleepBeforeRetry(long timeToSleep) {
        try {
            Thread.sleep(timeToSleep);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

