/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.twitter.api.impl;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.social.twitter.api.Trend;
import org.springframework.social.twitter.api.Trends;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AbstractTrendsList {
    private final List<Trends> list;

    public AbstractTrendsList(Map<String, List<Trend>> trends, DateFormat dateFormat) {
        this.list = new ArrayList<Trends>(trends.size());
        for (Map.Entry<String, List<Trend>> entry : trends.entrySet()) {
            this.list.add(new Trends(this.toDate(entry.getKey(), dateFormat), entry.getValue()));
        }
        Collections.sort(this.list, new Comparator<Trends>(){

            @Override
            public int compare(Trends t1, Trends t2) {
                return t1.getTime().getTime() > t2.getTime().getTime() ? -1 : 1;
            }
        });
    }

    public List<Trends> getList() {
        return this.list;
    }

    protected Date toDate(String dateString, DateFormat dateFormat) {
        if (dateString == null) {
            return null;
        }
        try {
            return dateFormat.parse(dateString);
        }
        catch (ParseException e) {
            return null;
        }
    }
}

