/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers;

import jakarta.servlet.Filter;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.util.Assert;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

public class CorsConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractHttpConfigurer<CorsConfigurer<H>, H> {
    private static final String CORS_CONFIGURATION_SOURCE_BEAN_NAME = "corsConfigurationSource";
    private static final String CORS_FILTER_BEAN_NAME = "corsFilter";
    private CorsConfigurationSource configurationSource;

    public CorsConfigurer<H> configurationSource(CorsConfigurationSource configurationSource) {
        this.configurationSource = configurationSource;
        return this;
    }

    @Override
    public void configure(H http) {
        ApplicationContext context = http.getSharedObject(ApplicationContext.class);
        CorsFilter corsFilter = this.getCorsFilter(context);
        Assert.state((corsFilter != null ? 1 : 0) != 0, () -> "Please configure either a corsFilter bean or a corsConfigurationSourcebean.");
        http.addFilter((Filter)corsFilter);
    }

    private CorsFilter getCorsFilter(ApplicationContext context) {
        if (this.configurationSource != null) {
            return new CorsFilter(this.configurationSource);
        }
        boolean containsCorsFilter = context.containsBeanDefinition(CORS_FILTER_BEAN_NAME);
        if (containsCorsFilter) {
            return (CorsFilter)context.getBean(CORS_FILTER_BEAN_NAME, CorsFilter.class);
        }
        boolean containsCorsSource = context.containsBean(CORS_CONFIGURATION_SOURCE_BEAN_NAME);
        if (containsCorsSource) {
            CorsConfigurationSource configurationSource = (CorsConfigurationSource)context.getBean(CORS_CONFIGURATION_SOURCE_BEAN_NAME, CorsConfigurationSource.class);
            return new CorsFilter(configurationSource);
        }
        return MvcCorsFilter.getMvcCorsFilter(context);
    }

    static class MvcCorsFilter {
        private static final String HANDLER_MAPPING_INTROSPECTOR_BEAN_NAME = "mvcHandlerMappingIntrospector";

        MvcCorsFilter() {
        }

        private static CorsFilter getMvcCorsFilter(ApplicationContext context) {
            if (context.containsBean(HANDLER_MAPPING_INTROSPECTOR_BEAN_NAME)) {
                CorsConfigurationSource corsConfigurationSource = (CorsConfigurationSource)context.getBean(HANDLER_MAPPING_INTROSPECTOR_BEAN_NAME, CorsConfigurationSource.class);
                return new CorsFilter(corsConfigurationSource);
            }
            throw new NoSuchBeanDefinitionException(CorsConfigurationSource.class, "Failed to find a bean that implements `CorsConfigurationSource`. Please ensure that you are using `@EnableWebMvc`, are publishing a `WebMvcConfigurer`, or are publishing a `CorsConfigurationSource` bean.");
        }
    }
}

