/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.DefaultTuple;
import org.springframework.data.redis.connection.ReactiveZSetCommands;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.core.DefaultTypedTuple;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.data.redis.core.ReactiveZSetOperations;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.util.ByteUtils;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class DefaultReactiveZSetOperations<K, V>
implements ReactiveZSetOperations<K, V> {
    private final ReactiveRedisTemplate<?, ?> template;
    private final RedisSerializationContext<K, V> serializationContext;

    public DefaultReactiveZSetOperations(ReactiveRedisTemplate<?, ?> template, RedisSerializationContext<K, V> serializationContext) {
        this.template = template;
        this.serializationContext = serializationContext;
    }

    @Override
    public Mono<Boolean> add(K key, V value, double score) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.createMono(connection -> connection.zAdd(this.rawKey(key), score, this.rawValue(value)).map(l -> l != 0L));
    }

    @Override
    public Mono<Long> addAll(K key, Collection<? extends ZSetOperations.TypedTuple<V>> tuples) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(tuples, (String)"Key must not be null!");
        return this.createMono(connection -> Flux.fromIterable((Iterable)tuples).map(t -> new DefaultTuple(ByteUtils.getBytes(this.rawValue(t.getValue())), t.getScore())).collectList().flatMap(serialized -> connection.zAdd(this.rawKey(key), (Collection<? extends RedisZSetCommands.Tuple>)serialized)));
    }

    @Override
    public Mono<Long> remove(K key, Object ... values) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull((Object)values, (String)"Values must not be null!");
        if (values.length == 1) {
            return this.createMono(connection -> connection.zRem(this.rawKey(key), this.rawValue(values[0])));
        }
        return this.createMono(connection -> Flux.fromArray((Object[])values).map(this::rawValue).collectList().flatMap(serialized -> connection.zRem(this.rawKey(key), (Collection<ByteBuffer>)serialized)));
    }

    @Override
    public Mono<Double> incrementScore(K key, V value, double delta) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.createMono(connection -> connection.zIncrBy(this.rawKey(key), delta, this.rawValue(value)));
    }

    @Override
    public Mono<V> randomMember(K key) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.createMono(connection -> connection.zRandMember(this.rawKey(key))).map(this::readValue);
    }

    @Override
    public Flux<V> distinctRandomMembers(K key, long count) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.isTrue((count > 0L ? 1 : 0) != 0, (String)"Negative count not supported. Use randomMembers to allow duplicate elements.");
        return this.createFlux(connection -> connection.zRandMember(this.rawKey(key), count)).map(this::readValue);
    }

    @Override
    public Flux<V> randomMembers(K key, long count) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.isTrue((count > 0L ? 1 : 0) != 0, (String)"Use a positive number for count. This method is already allowing duplicate elements.");
        return this.createFlux(connection -> connection.zRandMember(this.rawKey(key), -count)).map(this::readValue);
    }

    @Override
    public Mono<ZSetOperations.TypedTuple<V>> randomMemberWithScore(K key) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.createMono(connection -> connection.zRandMemberWithScore(this.rawKey(key))).map(this::readTypedTuple);
    }

    @Override
    public Flux<ZSetOperations.TypedTuple<V>> distinctRandomMembersWithScore(K key, long count) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.isTrue((count > 0L ? 1 : 0) != 0, (String)"Negative count not supported. Use randomMembers to allow duplicate elements.");
        return this.createFlux(connection -> connection.zRandMemberWithScore(this.rawKey(key), count)).map(this::readTypedTuple);
    }

    @Override
    public Flux<ZSetOperations.TypedTuple<V>> randomMembersWithScore(K key, long count) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.isTrue((count > 0L ? 1 : 0) != 0, (String)"Use a positive number for count. This method is already allowing duplicate elements.");
        return this.createFlux(connection -> connection.zRandMemberWithScore(this.rawKey(key), -count)).map(this::readTypedTuple);
    }

    @Override
    public Mono<Long> rank(K key, Object o) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.createMono(connection -> connection.zRank(this.rawKey(key), this.rawValue(o)));
    }

    @Override
    public Mono<Long> reverseRank(K key, Object o) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.createMono(connection -> connection.zRevRank(this.rawKey(key), this.rawValue(o)));
    }

    @Override
    public Flux<V> range(K key, Range<Long> range) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        return this.createFlux(connection -> connection.zRange(this.rawKey(key), range).map(this::readValue));
    }

    @Override
    public Flux<ZSetOperations.TypedTuple<V>> rangeWithScores(K key, Range<Long> range) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        return this.createFlux(connection -> connection.zRangeWithScores(this.rawKey(key), range).map(this::readTypedTuple));
    }

    @Override
    public Flux<V> rangeByScore(K key, Range<Double> range) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        return this.createFlux(connection -> connection.zRangeByScore(this.rawKey(key), range).map(this::readValue));
    }

    @Override
    public Flux<ZSetOperations.TypedTuple<V>> rangeByScoreWithScores(K key, Range<Double> range) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        return this.createFlux(connection -> connection.zRangeByScoreWithScores(this.rawKey(key), range).map(this::readTypedTuple));
    }

    @Override
    public Flux<V> rangeByScore(K key, Range<Double> range, RedisZSetCommands.Limit limit) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        return this.createFlux(connection -> connection.zRangeByScore(this.rawKey(key), range, limit).map(this::readValue));
    }

    @Override
    public Flux<ZSetOperations.TypedTuple<V>> rangeByScoreWithScores(K key, Range<Double> range, RedisZSetCommands.Limit limit) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        Assert.notNull((Object)limit, (String)"Limit must not be null!");
        return this.createFlux(connection -> connection.zRangeByScoreWithScores(this.rawKey(key), range, limit).map(this::readTypedTuple));
    }

    @Override
    public Flux<V> reverseRange(K key, Range<Long> range) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        return this.createFlux(connection -> connection.zRevRange(this.rawKey(key), range).map(this::readValue));
    }

    @Override
    public Flux<ZSetOperations.TypedTuple<V>> reverseRangeWithScores(K key, Range<Long> range) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        return this.createFlux(connection -> connection.zRevRangeWithScores(this.rawKey(key), range).map(this::readTypedTuple));
    }

    @Override
    public Flux<V> reverseRangeByScore(K key, Range<Double> range) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        return this.createFlux(connection -> connection.zRevRangeByScore(this.rawKey(key), range).map(this::readValue));
    }

    @Override
    public Flux<ZSetOperations.TypedTuple<V>> reverseRangeByScoreWithScores(K key, Range<Double> range) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        return this.createFlux(connection -> connection.zRevRangeByScoreWithScores(this.rawKey(key), range).map(this::readTypedTuple));
    }

    @Override
    public Flux<V> reverseRangeByScore(K key, Range<Double> range, RedisZSetCommands.Limit limit) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        return this.createFlux(connection -> connection.zRevRangeByScore(this.rawKey(key), range, limit).map(this::readValue));
    }

    @Override
    public Flux<ZSetOperations.TypedTuple<V>> reverseRangeByScoreWithScores(K key, Range<Double> range, RedisZSetCommands.Limit limit) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        Assert.notNull((Object)limit, (String)"Limit must not be null!");
        return this.createFlux(connection -> connection.zRevRangeByScoreWithScores(this.rawKey(key), range, limit).map(this::readTypedTuple));
    }

    @Override
    public Flux<ZSetOperations.TypedTuple<V>> scan(K key, ScanOptions options) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull((Object)options, (String)"ScanOptions must not be null!");
        return this.createFlux(connection -> connection.zScan(this.rawKey(key), options).map(this::readTypedTuple));
    }

    @Override
    public Mono<Long> count(K key, Range<Double> range) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        return this.createMono(connection -> connection.zCount(this.rawKey(key), range));
    }

    @Override
    public Mono<Long> lexCount(K key, Range<String> range) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        return this.createMono(connection -> connection.zLexCount(this.rawKey(key), range));
    }

    @Override
    public Mono<ZSetOperations.TypedTuple<V>> popMin(K key) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.createMono(connection -> connection.zPopMin(this.rawKey(key)).map(this::readTypedTuple));
    }

    @Override
    public Flux<ZSetOperations.TypedTuple<V>> popMin(K key, long count) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.createFlux(connection -> connection.zPopMin(this.rawKey(key), count).map(this::readTypedTuple));
    }

    @Override
    public Mono<ZSetOperations.TypedTuple<V>> popMin(K key, Duration timeout) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull((Object)timeout, (String)"Timeout must not be null!");
        return this.createMono(connection -> connection.bZPopMin(this.rawKey(key), timeout).map(this::readTypedTuple));
    }

    @Override
    public Mono<ZSetOperations.TypedTuple<V>> popMax(K key) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.createMono(connection -> connection.zPopMax(this.rawKey(key)).map(this::readTypedTuple));
    }

    @Override
    public Flux<ZSetOperations.TypedTuple<V>> popMax(K key, long count) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.createFlux(connection -> connection.zPopMax(this.rawKey(key), count).map(this::readTypedTuple));
    }

    @Override
    public Mono<ZSetOperations.TypedTuple<V>> popMax(K key, Duration timeout) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull((Object)timeout, (String)"Timeout must not be null!");
        return this.createMono(connection -> connection.bZPopMax(this.rawKey(key), timeout).map(this::readTypedTuple));
    }

    @Override
    public Mono<Long> size(K key) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.createMono(connection -> connection.zCard(this.rawKey(key)));
    }

    @Override
    public Mono<Double> score(K key, Object o) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.createMono(connection -> connection.zScore(this.rawKey(key), this.rawValue(o)));
    }

    @Override
    public Mono<List<Double>> score(K key, Object ... o) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.createMono(connection -> Flux.fromArray((Object[])o).map(this::rawValue).collectList().flatMap(values -> connection.zMScore(this.rawKey(key), (Collection<ByteBuffer>)values)));
    }

    @Override
    public Mono<Long> removeRange(K key, Range<Long> range) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        return this.createMono(connection -> connection.zRemRangeByRank(this.rawKey(key), range));
    }

    @Override
    public Mono<Long> removeRangeByLex(K key, Range<String> range) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        return this.createMono(connection -> connection.zRemRangeByLex(this.rawKey(key), range));
    }

    @Override
    public Mono<Long> removeRangeByScore(K key, Range<Double> range) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        return this.createMono(connection -> connection.zRemRangeByScore(this.rawKey(key), range));
    }

    @Override
    public Flux<V> difference(K key, Collection<K> otherKeys) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(otherKeys, (String)"Other keys must not be null!");
        return this.createFlux(connection -> Flux.fromIterable(this.getKeys(key, otherKeys)).map(this::rawKey).collectList().flatMapMany(connection::zDiff).map(this::readValue));
    }

    @Override
    public Flux<ZSetOperations.TypedTuple<V>> differenceWithScores(K key, Collection<K> otherKeys) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(otherKeys, (String)"Other keys must not be null!");
        return this.createFlux(connection -> Flux.fromIterable(this.getKeys(key, otherKeys)).map(this::rawKey).collectList().flatMapMany(connection::zDiffWithScores).map(this::readTypedTuple));
    }

    @Override
    public Mono<Long> differenceAndStore(K key, Collection<K> otherKeys, K destKey) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(otherKeys, (String)"Other keys must not be null!");
        Assert.notNull(destKey, (String)"Destination key must not be null!");
        return this.createMono(connection -> Flux.fromIterable(this.getKeys(key, otherKeys)).map(this::rawKey).collectList().flatMap(serialized -> connection.zDiffStore(this.rawKey(destKey), (List<ByteBuffer>)serialized)));
    }

    @Override
    public Flux<V> intersect(K key, Collection<K> otherKeys) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(otherKeys, (String)"Other keys must not be null!");
        return this.createFlux(connection -> Flux.fromIterable(this.getKeys(key, otherKeys)).map(this::rawKey).collectList().flatMapMany(connection::zInter).map(this::readValue));
    }

    @Override
    public Flux<ZSetOperations.TypedTuple<V>> intersectWithScores(K key, Collection<K> otherKeys) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(otherKeys, (String)"Other keys must not be null!");
        return this.createFlux(connection -> Flux.fromIterable(this.getKeys(key, otherKeys)).map(this::rawKey).collectList().flatMapMany(connection::zInterWithScores).map(this::readTypedTuple));
    }

    @Override
    public Flux<ZSetOperations.TypedTuple<V>> intersectWithScores(K key, Collection<K> otherKeys, RedisZSetCommands.Aggregate aggregate, RedisZSetCommands.Weights weights) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(otherKeys, (String)"Other keys must not be null!");
        Assert.notNull((Object)((Object)aggregate), (String)"Aggregate must not be null!");
        Assert.notNull((Object)weights, (String)"Weights must not be null!");
        return this.createFlux(connection -> Flux.fromIterable(this.getKeys(key, otherKeys)).map(this::rawKey).collectList().flatMapMany(sets -> connection.zInterWithScores((List<ByteBuffer>)sets, weights, aggregate)).map(this::readTypedTuple));
    }

    @Override
    public Mono<Long> intersectAndStore(K key, Collection<K> otherKeys, K destKey) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(otherKeys, (String)"Other keys must not be null!");
        Assert.notNull(destKey, (String)"Destination key must not be null!");
        return this.createMono(connection -> Flux.fromIterable(this.getKeys(key, otherKeys)).map(this::rawKey).collectList().flatMap(serialized -> connection.zInterStore(this.rawKey(destKey), (List<ByteBuffer>)serialized)));
    }

    @Override
    public Mono<Long> intersectAndStore(K key, Collection<K> otherKeys, K destKey, RedisZSetCommands.Aggregate aggregate, RedisZSetCommands.Weights weights) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(otherKeys, (String)"Other keys must not be null!");
        Assert.notNull(destKey, (String)"Destination key must not be null!");
        Assert.notNull((Object)((Object)aggregate), (String)"Aggregate must not be null!");
        Assert.notNull((Object)weights, (String)"Weights must not be null!");
        return this.createMono(connection -> Flux.fromIterable(this.getKeys(key, otherKeys)).map(this::rawKey).collectList().flatMap(serialized -> connection.zInterStore(this.rawKey(destKey), (List<ByteBuffer>)serialized, weights, aggregate)));
    }

    @Override
    public Flux<V> union(K key, Collection<K> otherKeys) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(otherKeys, (String)"Other keys must not be null!");
        return this.createFlux(connection -> Flux.fromIterable(this.getKeys(key, otherKeys)).map(this::rawKey).collectList().flatMapMany(connection::zUnion).map(this::readValue));
    }

    @Override
    public Flux<ZSetOperations.TypedTuple<V>> unionWithScores(K key, Collection<K> otherKeys) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(otherKeys, (String)"Other keys must not be null!");
        return this.createFlux(connection -> Flux.fromIterable(this.getKeys(key, otherKeys)).map(this::rawKey).collectList().flatMapMany(connection::zUnionWithScores).map(this::readTypedTuple));
    }

    @Override
    public Flux<ZSetOperations.TypedTuple<V>> unionWithScores(K key, Collection<K> otherKeys, RedisZSetCommands.Aggregate aggregate, RedisZSetCommands.Weights weights) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(otherKeys, (String)"Other keys must not be null!");
        Assert.notNull((Object)((Object)aggregate), (String)"Aggregate must not be null!");
        Assert.notNull((Object)weights, (String)"Weights must not be null!");
        return this.createFlux(connection -> Flux.fromIterable(this.getKeys(key, otherKeys)).map(this::rawKey).collectList().flatMapMany(sets -> connection.zUnionWithScores((List<ByteBuffer>)sets, weights, aggregate)).map(this::readTypedTuple));
    }

    @Override
    public Mono<Long> unionAndStore(K key, K otherKey, K destKey) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(otherKey, (String)"Other key must not be null!");
        Assert.notNull(destKey, (String)"Destination key must not be null!");
        return this.unionAndStore(key, (Collection<K>)Collections.singleton(otherKey), destKey);
    }

    @Override
    public Mono<Long> unionAndStore(K key, Collection<K> otherKeys, K destKey) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(otherKeys, (String)"Other keys must not be null!");
        Assert.notNull(destKey, (String)"Destination key must not be null!");
        return this.createMono(connection -> Flux.fromIterable(this.getKeys(key, otherKeys)).map(this::rawKey).collectList().flatMap(serialized -> connection.zUnionStore(this.rawKey(destKey), (List<ByteBuffer>)serialized)));
    }

    @Override
    public Mono<Long> unionAndStore(K key, Collection<K> otherKeys, K destKey, RedisZSetCommands.Aggregate aggregate, RedisZSetCommands.Weights weights) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(otherKeys, (String)"Other keys must not be null!");
        Assert.notNull(destKey, (String)"Destination key must not be null!");
        Assert.notNull((Object)((Object)aggregate), (String)"Aggregate must not be null!");
        Assert.notNull((Object)weights, (String)"Weights must not be null!");
        return this.createMono(connection -> Flux.fromIterable(this.getKeys(key, otherKeys)).map(this::rawKey).collectList().flatMap(serialized -> connection.zUnionStore(this.rawKey(destKey), (List<ByteBuffer>)serialized, weights, aggregate)));
    }

    @Override
    public Flux<V> rangeByLex(K key, Range<String> range) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        return this.createFlux(connection -> connection.zRangeByLex(this.rawKey(key), range).map(this::readValue));
    }

    @Override
    public Flux<V> rangeByLex(K key, Range<String> range, RedisZSetCommands.Limit limit) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        Assert.notNull((Object)limit, (String)"Limit must not be null!");
        return this.createFlux(connection -> connection.zRangeByLex(this.rawKey(key), range, limit).map(this::readValue));
    }

    @Override
    public Flux<V> reverseRangeByLex(K key, Range<String> range) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        return this.createFlux(connection -> connection.zRevRangeByLex(this.rawKey(key), range).map(this::readValue));
    }

    @Override
    public Flux<V> reverseRangeByLex(K key, Range<String> range, RedisZSetCommands.Limit limit) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        Assert.notNull((Object)limit, (String)"Limit must not be null!");
        return this.createFlux(connection -> connection.zRevRangeByLex(this.rawKey(key), range, limit).map(this::readValue));
    }

    @Override
    public Mono<Boolean> delete(K key) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.template.doCreateMono(connection -> connection.keyCommands().del(this.rawKey(key))).map(l -> l != 0L);
    }

    private <T> Mono<T> createMono(Function<ReactiveZSetCommands, Publisher<T>> function) {
        Assert.notNull(function, (String)"Function must not be null!");
        return this.template.doCreateMono(connection -> (Publisher)function.apply(connection.zSetCommands()));
    }

    private <T> Flux<T> createFlux(Function<ReactiveZSetCommands, Publisher<T>> function) {
        Assert.notNull(function, (String)"Function must not be null!");
        return this.template.doCreateFlux(connection -> (Publisher)function.apply(connection.zSetCommands()));
    }

    private ByteBuffer rawKey(K key) {
        return this.serializationContext.getKeySerializationPair().write(key);
    }

    private List<K> getKeys(K key, Collection<K> otherKeys) {
        ArrayList<K> keys = new ArrayList<K>(1 + otherKeys.size());
        keys.add(key);
        keys.addAll(otherKeys);
        return keys;
    }

    private ByteBuffer rawValue(V value) {
        return this.serializationContext.getValueSerializationPair().write(value);
    }

    private V readValue(ByteBuffer buffer) {
        return this.serializationContext.getValueSerializationPair().read(buffer);
    }

    private ZSetOperations.TypedTuple<V> readTypedTuple(RedisZSetCommands.Tuple raw) {
        return new DefaultTypedTuple<V>(this.readValue(ByteBuffer.wrap(raw.getValue())), raw.getScore());
    }
}

