/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.repository.configuration;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.data.keyvalue.repository.config.KeyValueRepositoryConfigurationExtension;
import org.springframework.data.redis.core.RedisHash;
import org.springframework.data.redis.core.RedisKeyValueAdapter;
import org.springframework.data.redis.core.RedisKeyValueTemplate;
import org.springframework.data.redis.core.convert.CustomConversions;
import org.springframework.data.redis.core.convert.MappingConfiguration;
import org.springframework.data.redis.core.convert.MappingRedisConverter;
import org.springframework.data.redis.core.mapping.RedisMappingContext;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.util.StringUtils;

public class RedisRepositoryConfigurationExtension
extends KeyValueRepositoryConfigurationExtension {
    private static final String REDIS_CONVERTER_BEAN_NAME = "redisConverter";
    private static final String REDIS_REFERENCE_RESOLVER_BEAN_NAME = "redisReferenceResolver";
    private static final String REDIS_ADAPTER_BEAN_NAME = "redisKeyValueAdapter";
    private static final String REDIS_CUSTOM_CONVERSIONS_BEAN_NAME = "redisCustomConversions";

    public String getModuleName() {
        return "Redis";
    }

    protected String getModulePrefix() {
        return "redis";
    }

    protected String getDefaultKeyValueTemplateRef() {
        return "redisKeyValueTemplate";
    }

    public void registerBeansForRoot(BeanDefinitionRegistry registry, RepositoryConfigurationSource configurationSource) {
        String redisTemplateRef = configurationSource.getAttribute("redisTemplateRef");
        RootBeanDefinition mappingContextDefinition = this.createRedisMappingContext(configurationSource);
        mappingContextDefinition.setSource(configurationSource.getSource());
        RedisRepositoryConfigurationExtension.registerIfNotAlreadyRegistered((AbstractBeanDefinition)mappingContextDefinition, (BeanDefinitionRegistry)registry, (String)"keyValueMappingContext", (Object)configurationSource);
        RootBeanDefinition customConversions = new RootBeanDefinition(CustomConversions.class);
        RedisRepositoryConfigurationExtension.registerIfNotAlreadyRegistered((AbstractBeanDefinition)customConversions, (BeanDefinitionRegistry)registry, (String)REDIS_CUSTOM_CONVERSIONS_BEAN_NAME, (Object)configurationSource);
        RootBeanDefinition redisReferenceResolver = this.createRedisReferenceResolverDefinition(redisTemplateRef);
        redisReferenceResolver.setSource(configurationSource.getSource());
        RedisRepositoryConfigurationExtension.registerIfNotAlreadyRegistered((AbstractBeanDefinition)redisReferenceResolver, (BeanDefinitionRegistry)registry, (String)REDIS_REFERENCE_RESOLVER_BEAN_NAME, (Object)configurationSource);
        RootBeanDefinition redisConverterDefinition = this.createRedisConverterDefinition();
        redisConverterDefinition.setSource(configurationSource.getSource());
        RedisRepositoryConfigurationExtension.registerIfNotAlreadyRegistered((AbstractBeanDefinition)redisConverterDefinition, (BeanDefinitionRegistry)registry, (String)REDIS_CONVERTER_BEAN_NAME, (Object)configurationSource);
        RootBeanDefinition redisKeyValueAdapterDefinition = new RootBeanDefinition(RedisKeyValueAdapter.class);
        ConstructorArgumentValues constructorArgumentValuesForRedisKeyValueAdapter = new ConstructorArgumentValues();
        if (StringUtils.hasText((String)redisTemplateRef)) {
            constructorArgumentValuesForRedisKeyValueAdapter.addIndexedArgumentValue(0, (Object)new RuntimeBeanReference(redisTemplateRef));
        }
        constructorArgumentValuesForRedisKeyValueAdapter.addIndexedArgumentValue(1, (Object)new RuntimeBeanReference(REDIS_CONVERTER_BEAN_NAME));
        redisKeyValueAdapterDefinition.setConstructorArgumentValues(constructorArgumentValuesForRedisKeyValueAdapter);
        DirectFieldAccessor fieldAccessor = new DirectFieldAccessor((Object)configurationSource);
        AnnotationAttributes attributes = (AnnotationAttributes)fieldAccessor.getPropertyValue("attributes");
        MutablePropertyValues redisKeyValueAdapterProps = new MutablePropertyValues();
        redisKeyValueAdapterProps.add("enableKeyspaceEvents", (Object)attributes.getEnum("enableKeyspaceEvents"));
        redisKeyValueAdapterDefinition.setPropertyValues(redisKeyValueAdapterProps);
        RedisRepositoryConfigurationExtension.registerIfNotAlreadyRegistered((AbstractBeanDefinition)redisKeyValueAdapterDefinition, (BeanDefinitionRegistry)registry, (String)REDIS_ADAPTER_BEAN_NAME, (Object)configurationSource);
        super.registerBeansForRoot(registry, configurationSource);
    }

    private RootBeanDefinition createRedisReferenceResolverDefinition(String redisTemplateRef) {
        RootBeanDefinition beanDef = new RootBeanDefinition();
        beanDef.setBeanClassName("org.springframework.data.redis.core.convert.ReferenceResolverImpl");
        ConstructorArgumentValues constructorArgs = new ConstructorArgumentValues();
        constructorArgs.addIndexedArgumentValue(0, (Object)new RuntimeBeanReference(redisTemplateRef));
        beanDef.setConstructorArgumentValues(constructorArgs);
        return beanDef;
    }

    private RootBeanDefinition createRedisMappingContext(RepositoryConfigurationSource configurationSource) {
        ConstructorArgumentValues mappingContextArgs = new ConstructorArgumentValues();
        mappingContextArgs.addIndexedArgumentValue(0, (Object)this.createMappingConfigBeanDef(configurationSource));
        RootBeanDefinition mappingContextBeanDef = new RootBeanDefinition(RedisMappingContext.class);
        mappingContextBeanDef.setConstructorArgumentValues(mappingContextArgs);
        return mappingContextBeanDef;
    }

    private BeanDefinition createMappingConfigBeanDef(RepositoryConfigurationSource configurationSource) {
        DirectFieldAccessor dfa = new DirectFieldAccessor((Object)configurationSource);
        AnnotationAttributes aa = (AnnotationAttributes)dfa.getPropertyValue("attributes");
        GenericBeanDefinition indexConfiguration = new GenericBeanDefinition();
        indexConfiguration.setBeanClass(aa.getClass("indexConfiguration"));
        GenericBeanDefinition keyspaceConfig = new GenericBeanDefinition();
        keyspaceConfig.setBeanClass(aa.getClass("keyspaceConfiguration"));
        ConstructorArgumentValues mappingConfigArgs = new ConstructorArgumentValues();
        mappingConfigArgs.addIndexedArgumentValue(0, (Object)indexConfiguration);
        mappingConfigArgs.addIndexedArgumentValue(1, (Object)keyspaceConfig);
        GenericBeanDefinition mappingConfigBeanDef = new GenericBeanDefinition();
        mappingConfigBeanDef.setBeanClass(MappingConfiguration.class);
        mappingConfigBeanDef.setConstructorArgumentValues(mappingConfigArgs);
        return mappingConfigBeanDef;
    }

    protected AbstractBeanDefinition getDefaultKeyValueTemplateBeanDefinition(RepositoryConfigurationSource configurationSource) {
        RootBeanDefinition keyValueTemplateDefinition = new RootBeanDefinition(RedisKeyValueTemplate.class);
        ConstructorArgumentValues constructorArgumentValuesForKeyValueTemplate = new ConstructorArgumentValues();
        constructorArgumentValuesForKeyValueTemplate.addIndexedArgumentValue(0, (Object)new RuntimeBeanReference(REDIS_ADAPTER_BEAN_NAME));
        constructorArgumentValuesForKeyValueTemplate.addIndexedArgumentValue(1, (Object)new RuntimeBeanReference("keyValueMappingContext"));
        keyValueTemplateDefinition.setConstructorArgumentValues(constructorArgumentValuesForKeyValueTemplate);
        return keyValueTemplateDefinition;
    }

    private RootBeanDefinition createRedisConverterDefinition() {
        RootBeanDefinition beanDef = new RootBeanDefinition();
        beanDef.setBeanClass(MappingRedisConverter.class);
        ConstructorArgumentValues args = new ConstructorArgumentValues();
        args.addIndexedArgumentValue(0, (Object)new RuntimeBeanReference("keyValueMappingContext"));
        beanDef.setConstructorArgumentValues(args);
        MutablePropertyValues props = new MutablePropertyValues();
        props.add("referenceResolver", (Object)new RuntimeBeanReference(REDIS_REFERENCE_RESOLVER_BEAN_NAME));
        props.add("customConversions", (Object)new RuntimeBeanReference(REDIS_CUSTOM_CONVERSIONS_BEAN_NAME));
        beanDef.setPropertyValues(props);
        return beanDef;
    }

    protected Collection<Class<? extends Annotation>> getIdentifyingAnnotations() {
        return Collections.singleton(RedisHash.class);
    }
}

