/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.support;

import com.mongodb.DBRef;
import com.querydsl.core.types.Constant;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Operation;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.PathType;
import com.querydsl.mongodb.document.MongodbDocumentSerializer;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.bson.Document;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.QueryMapper;
import org.springframework.data.mongodb.core.mapping.FieldName;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

class SpringDataMongodbSerializer
extends MongodbDocumentSerializer {
    private static final String ID_KEY = FieldName.ID.name();
    private static final Set<PathType> PATH_TYPES = Set.of(PathType.VARIABLE, PathType.PROPERTY);
    private final MongoConverter converter;
    private final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;
    private final QueryMapper mapper;

    public SpringDataMongodbSerializer(MongoConverter converter) {
        Assert.notNull((Object)converter, (String)"MongoConverter must not be null");
        this.mappingContext = converter.getMappingContext();
        this.converter = converter;
        this.mapper = new QueryMapper(converter);
    }

    public Object visit(Constant<?> expr, Void context) {
        if (!ClassUtils.isAssignable(Enum.class, (Class)expr.getType())) {
            return super.visit(expr, context);
        }
        return this.converter.convertToMongoType(expr.getConstant());
    }

    protected String getKeyForPath(Path<?> expr, PathMetadata metadata) {
        if (!metadata.getPathType().equals((Object)PathType.PROPERTY)) {
            return super.getKeyForPath(expr, metadata);
        }
        Path parent = metadata.getParent();
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getRequiredPersistentEntity(parent.getType());
        MongoPersistentProperty property = (MongoPersistentProperty)entity.getPersistentProperty(metadata.getName());
        return property == null ? super.getKeyForPath(expr, metadata) : property.getFieldName();
    }

    protected Document asDocument(@Nullable String key, @Nullable Object value) {
        Object object;
        if (value instanceof Optional) {
            Optional optional = (Optional)value;
            object = optional.orElse(null);
        } else {
            object = value;
        }
        value = object;
        return super.asDocument(key, value instanceof Pattern ? value : this.converter.convertToMongoType(value));
    }

    protected boolean isReference(@Nullable Path<?> path) {
        MongoPersistentProperty property = this.getPropertyForPotentialDbRef(path);
        return property != null && property.isAssociation();
    }

    protected DBRef asReference(@Nullable Object constant) {
        return this.asReference(constant, null);
    }

    protected DBRef asReference(Object constant, Path<?> path) {
        return this.converter.toDBRef(constant, this.getPropertyForPotentialDbRef(path));
    }

    protected String asDBKey(@Nullable Operation<?> expr, int index) {
        Expression arg = expr.getArg(index);
        String key = super.asDBKey(expr, index);
        if (!(arg instanceof Path)) {
            return key;
        }
        Path path = (Path)arg;
        if (!this.isReference(path)) {
            return key;
        }
        MongoPersistentProperty property = this.getPropertyFor(path);
        return property.isIdProperty() ? key.replaceAll("." + ID_KEY + "$", "") : key;
    }

    protected Object convert(@Nullable Path<?> path, @Nullable Constant<?> constant) {
        if (!this.isReference(path)) {
            return super.convert(path, constant);
        }
        MongoPersistentProperty property = this.getPropertyFor(path);
        if (property.isDocumentReference()) {
            return this.converter.toDocumentPointer(constant.getConstant(), property).getPointer();
        }
        if (property.isIdProperty()) {
            MongoPersistentProperty propertyForPotentialDbRef = this.getPropertyForPotentialDbRef(path);
            if (propertyForPotentialDbRef != null && propertyForPotentialDbRef.isDocumentReference()) {
                return this.converter.toDocumentPointer(constant.getConstant(), propertyForPotentialDbRef).getPointer();
            }
            return this.asReference(constant.getConstant(), path.getMetadata().getParent());
        }
        return this.asReference(constant.getConstant(), path);
    }

    @Nullable
    private MongoPersistentProperty getPropertyFor(Path<?> path) {
        Path parent = path.getMetadata().getParent();
        if (parent == null || !PATH_TYPES.contains(path.getMetadata().getPathType())) {
            return null;
        }
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(parent.getType());
        return entity != null ? (MongoPersistentProperty)entity.getPersistentProperty(path.getMetadata().getName()) : null;
    }

    private MongoPersistentProperty getPropertyForPotentialDbRef(Path<?> path) {
        if (path == null) {
            return null;
        }
        MongoPersistentProperty property = this.getPropertyFor(path);
        PathMetadata metadata = path.getMetadata();
        if (property != null && property.isIdProperty() && metadata != null && metadata.getParent() != null) {
            return this.getPropertyFor(metadata.getParent());
        }
        return property;
    }
}

