/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.support;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.core.NamedThreadLocal;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.data.mongodb.repository.ReadPreference;
import org.springframework.data.mongodb.repository.support.CrudMethodMetadata;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.support.RepositoryProxyPostProcessor;
import org.springframework.lang.Nullable;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

class CrudMethodMetadataPostProcessor
implements RepositoryProxyPostProcessor,
BeanClassLoaderAware {
    @Nullable
    private ClassLoader classLoader = ClassUtils.getDefaultClassLoader();

    CrudMethodMetadataPostProcessor() {
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void postProcess(ProxyFactory factory, RepositoryInformation repositoryInformation) {
        factory.addAdvice((Advice)new CrudMethodMetadataPopulatingMethodInterceptor(repositoryInformation));
    }

    CrudMethodMetadata getCrudMethodMetadata() {
        ProxyFactory factory = new ProxyFactory();
        factory.addInterface(CrudMethodMetadata.class);
        factory.setTargetSource((TargetSource)new ThreadBoundTargetSource());
        return (CrudMethodMetadata)factory.getProxy(this.classLoader);
    }

    static class CrudMethodMetadataPopulatingMethodInterceptor
    implements MethodInterceptor {
        private static final ThreadLocal<MethodInvocation> currentInvocation = new NamedThreadLocal("Current AOP method invocation");
        private final ConcurrentMap<Method, CrudMethodMetadata> metadataCache = new ConcurrentHashMap<Method, CrudMethodMetadata>();
        private final Set<Method> implementations = new HashSet<Method>();
        private final RepositoryInformation repositoryInformation;

        CrudMethodMetadataPopulatingMethodInterceptor(RepositoryInformation repositoryInformation) {
            this.repositoryInformation = repositoryInformation;
            ReflectionUtils.doWithMethods((Class)repositoryInformation.getRepositoryInterface(), this.implementations::add, method -> !repositoryInformation.isQueryMethod(method));
        }

        static MethodInvocation currentInvocation() throws IllegalStateException {
            MethodInvocation invocation = currentInvocation.get();
            if (invocation != null) {
                return invocation;
            }
            throw new IllegalStateException("No MethodInvocation found: Check that an AOP invocation is in progress, and that the CrudMethodMetadataPopulatingMethodInterceptor is upfront in the interceptor chain.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(MethodInvocation invocation) throws Throwable {
            Method method = invocation.getMethod();
            if (!this.implementations.contains(method)) {
                return invocation.proceed();
            }
            MethodInvocation oldInvocation = currentInvocation.get();
            currentInvocation.set(invocation);
            try {
                Object object;
                CrudMethodMetadata tmp;
                CrudMethodMetadata metadata = (CrudMethodMetadata)TransactionSynchronizationManager.getResource((Object)method);
                if (metadata != null) {
                    Object object2 = invocation.proceed();
                    return object2;
                }
                CrudMethodMetadata methodMetadata = (CrudMethodMetadata)this.metadataCache.get(method);
                if (methodMetadata == null && (tmp = this.metadataCache.putIfAbsent(method, methodMetadata = new DefaultCrudMethodMetadata(this.repositoryInformation.getRepositoryInterface(), method))) != null) {
                    methodMetadata = tmp;
                }
                TransactionSynchronizationManager.bindResource((Object)method, (Object)methodMetadata);
                try {
                    object = invocation.proceed();
                }
                catch (Throwable throwable) {
                    TransactionSynchronizationManager.unbindResource((Object)method);
                    throw throwable;
                }
                TransactionSynchronizationManager.unbindResource((Object)method);
                return object;
            }
            finally {
                currentInvocation.set(oldInvocation);
            }
        }
    }

    private static class ThreadBoundTargetSource
    implements TargetSource {
        private ThreadBoundTargetSource() {
        }

        public Class<?> getTargetClass() {
            return CrudMethodMetadata.class;
        }

        public boolean isStatic() {
            return false;
        }

        public Object getTarget() {
            MethodInvocation invocation = CrudMethodMetadataPopulatingMethodInterceptor.currentInvocation();
            return TransactionSynchronizationManager.getResource((Object)invocation.getMethod());
        }

        public void releaseTarget(Object target) {
        }
    }

    static class DefaultCrudMethodMetadata
    implements CrudMethodMetadata {
        private final Optional<com.mongodb.ReadPreference> readPreference;

        DefaultCrudMethodMetadata(Class<?> repositoryInterface, Method method) {
            Assert.notNull(repositoryInterface, (String)"Repository interface must not be null");
            Assert.notNull((Object)method, (String)"Method must not be null");
            this.readPreference = DefaultCrudMethodMetadata.findReadPreference(method, repositoryInterface);
        }

        private static Optional<com.mongodb.ReadPreference> findReadPreference(AnnotatedElement ... annotatedElements) {
            for (AnnotatedElement element : annotatedElements) {
                ReadPreference preference = (ReadPreference)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)element, ReadPreference.class);
                if (preference == null) continue;
                return Optional.of(com.mongodb.ReadPreference.valueOf((String)preference.value()));
            }
            return Optional.empty();
        }

        @Override
        public Optional<com.mongodb.ReadPreference> getReadPreference() {
            return this.readPreference;
        }
    }
}

