/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import org.springframework.data.jpa.repository.query.JpqlBaseVisitor;
import org.springframework.data.jpa.repository.query.JpqlParser;
import org.springframework.data.jpa.repository.query.JpqlQueryRenderer;
import org.springframework.data.jpa.repository.query.ParsedQueryIntrospector;
import org.springframework.data.jpa.repository.query.QueryInformation;
import org.springframework.data.jpa.repository.query.QueryInformationHolder;

class JpqlQueryIntrospector
extends JpqlBaseVisitor<Void>
implements ParsedQueryIntrospector<QueryInformation> {
    private final JpqlQueryRenderer renderer = new JpqlQueryRenderer();
    private final QueryInformationHolder introspection = new QueryInformationHolder();

    JpqlQueryIntrospector() {
    }

    @Override
    public QueryInformation getParsedQueryInformation() {
        return new QueryInformation(this.introspection);
    }

    @Override
    public Void visitSelectQuery(JpqlParser.SelectQueryContext ctx) {
        this.introspection.setStatementType(QueryInformation.StatementType.SELECT);
        return (Void)super.visitSelectQuery(ctx);
    }

    @Override
    public Void visitFromQuery(JpqlParser.FromQueryContext ctx) {
        this.introspection.setStatementType(QueryInformation.StatementType.SELECT);
        return (Void)super.visitFromQuery(ctx);
    }

    @Override
    public Void visitUpdate_statement(JpqlParser.Update_statementContext ctx) {
        this.introspection.setStatementType(QueryInformation.StatementType.UPDATE);
        return (Void)super.visitUpdate_statement(ctx);
    }

    @Override
    public Void visitDelete_statement(JpqlParser.Delete_statementContext ctx) {
        this.introspection.setStatementType(QueryInformation.StatementType.DELETE);
        return (Void)super.visitDelete_statement(ctx);
    }

    @Override
    public Void visitSelect_clause(JpqlParser.Select_clauseContext ctx) {
        this.introspection.captureProjection(ctx.select_item(), this.renderer::visitSelect_item);
        return (Void)super.visitSelect_clause(ctx);
    }

    @Override
    public Void visitRange_variable_declaration(JpqlParser.Range_variable_declarationContext ctx) {
        if (ctx.identification_variable() != null && !JpqlQueryRenderer.isSubquery(ctx) && !JpqlQueryRenderer.isSetQuery(ctx)) {
            this.introspection.capturePrimaryAlias(ctx.identification_variable().getText());
        }
        return (Void)super.visitRange_variable_declaration(ctx);
    }

    @Override
    public Void visitConstructor_expression(JpqlParser.Constructor_expressionContext ctx) {
        this.introspection.constructorExpressionPresent();
        return (Void)super.visitConstructor_expression(ctx);
    }
}

