/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.util;

import jakarta.persistence.Tuple;
import jakarta.persistence.TupleElement;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.springframework.jdbc.support.JdbcUtils;

public class TupleBackedMap
implements Map<String, Object> {
    private static final String UNMODIFIABLE_MESSAGE = "A TupleBackedMap cannot be modified";
    private final Tuple tuple;

    public TupleBackedMap(Tuple tuple) {
        this.tuple = tuple;
    }

    public static Tuple underscoreAware(Tuple delegate) {
        return new FallbackTupleWrapper(delegate);
    }

    @Override
    public int size() {
        return this.tuple.getElements().size();
    }

    @Override
    public boolean isEmpty() {
        return this.tuple.getElements().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        try {
            this.tuple.get((String)key);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    @Override
    public boolean containsValue(Object value) {
        return Arrays.asList(this.tuple.toArray()).contains(value);
    }

    @Override
    @Nullable
    public Object get(Object key) {
        if (!(key instanceof String)) {
            return null;
        }
        try {
            return this.tuple.get((String)key);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    @Override
    public Object put(String key, Object value) {
        throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
    }

    @Override
    public Set<String> keySet() {
        return this.tuple.getElements().stream().map(TupleElement::getAlias).collect(Collectors.toSet());
    }

    @Override
    public Collection<Object> values() {
        return Arrays.asList(this.tuple.toArray());
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.tuple.getElements().stream().map(e -> new AbstractMap.SimpleEntry<String, Object>(e.getAlias(), this.tuple.get(e))).collect(Collectors.toSet());
    }

    static class FallbackTupleWrapper
    implements Tuple {
        private final Tuple delegate;
        private final UnaryOperator<String> fallbackNameTransformer = JdbcUtils::convertPropertyNameToUnderscoreName;

        FallbackTupleWrapper(Tuple delegate) {
            this.delegate = delegate;
        }

        public <X> X get(TupleElement<X> tupleElement) {
            return this.get(tupleElement.getAlias(), tupleElement.getJavaType());
        }

        public <X> X get(String s, Class<X> type) {
            try {
                return (X)this.delegate.get(s, type);
            }
            catch (IllegalArgumentException original) {
                try {
                    return (X)this.delegate.get((String)this.fallbackNameTransformer.apply(s), type);
                }
                catch (IllegalArgumentException next) {
                    original.addSuppressed(next);
                    throw original;
                }
            }
        }

        public Object get(String s) {
            try {
                return this.delegate.get(s);
            }
            catch (IllegalArgumentException original) {
                try {
                    return this.delegate.get((String)this.fallbackNameTransformer.apply(s));
                }
                catch (IllegalArgumentException next) {
                    original.addSuppressed(next);
                    throw original;
                }
            }
        }

        public <X> X get(int i, Class<X> aClass) {
            return (X)this.delegate.get(i, aClass);
        }

        public Object get(int i) {
            return this.delegate.get(i);
        }

        public Object[] toArray() {
            return this.delegate.toArray();
        }

        public List<TupleElement<?>> getElements() {
            return this.delegate.getElements();
        }
    }
}

