/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.rsocket;

import io.netty.buffer.ByteBuf;
import io.rsocket.Payload;
import io.rsocket.RSocket;
import io.rsocket.frame.FrameType;
import io.rsocket.metadata.RoutingMetadata;
import io.rsocket.metadata.TracingMetadata;
import io.rsocket.metadata.TracingMetadataCodec;
import io.rsocket.metadata.WellKnownMimeType;
import io.rsocket.util.RSocketProxy;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.ThreadLocalSpan;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.docs.AssertingSpanBuilder;
import org.springframework.cloud.sleuth.docs.DocumentedSpan;
import org.springframework.cloud.sleuth.instrument.reactor.ReactorSleuth;
import org.springframework.cloud.sleuth.instrument.rsocket.CompositeMetadataUtils;
import org.springframework.cloud.sleuth.instrument.rsocket.PayloadUtils;
import org.springframework.cloud.sleuth.instrument.rsocket.SleuthRSocketSpan;
import org.springframework.cloud.sleuth.internal.EncodingUtils;
import org.springframework.cloud.sleuth.propagation.Propagator;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class TracingResponderRSocketProxy
extends RSocketProxy {
    private static final Log log = LogFactory.getLog(TracingResponderRSocketProxy.class);
    private final Propagator propagator;
    private final Propagator.Getter<ByteBuf> getter;
    private final Tracer tracer;
    private final ThreadLocalSpan threadLocalSpan;
    private final boolean isZipkinPropagationEnabled;

    public TracingResponderRSocketProxy(RSocket source, Propagator propagator, Propagator.Getter<ByteBuf> getter, Tracer tracer, boolean isZipkinPropagationEnabled) {
        super(source);
        this.propagator = propagator;
        this.getter = getter;
        this.tracer = tracer;
        this.threadLocalSpan = new ThreadLocalSpan(tracer);
        this.isZipkinPropagationEnabled = isZipkinPropagationEnabled;
    }

    public Mono<Void> fireAndForget(Payload payload) {
        this.clearThreadLocal();
        Span handle = this.consumerSpanBuilder(payload.sliceMetadata(), FrameType.REQUEST_FNF);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created consumer span " + handle));
        }
        Payload newPayload = PayloadUtils.cleanTracingMetadata(payload, new HashSet<String>(this.propagator.fields()));
        return ReactorSleuth.tracedMono(this.tracer, handle, () -> super.fireAndForget(newPayload));
    }

    private void clearThreadLocal() {
        this.tracer.withSpan(null);
    }

    public Mono<Payload> requestResponse(Payload payload) {
        this.clearThreadLocal();
        Span handle = this.consumerSpanBuilder(payload.sliceMetadata(), FrameType.REQUEST_RESPONSE);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created consumer span " + handle));
        }
        Payload newPayload = PayloadUtils.cleanTracingMetadata(payload, new HashSet<String>(this.propagator.fields()));
        return ReactorSleuth.tracedMono(this.tracer, handle, () -> super.requestResponse(newPayload));
    }

    public Flux<Payload> requestStream(Payload payload) {
        this.clearThreadLocal();
        Span handle = this.consumerSpanBuilder(payload.sliceMetadata(), FrameType.REQUEST_STREAM);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created consumer span " + handle));
        }
        Payload newPayload = PayloadUtils.cleanTracingMetadata(payload, new HashSet<String>(this.propagator.fields()));
        return ReactorSleuth.tracedFlux(this.tracer, handle, () -> super.requestStream(newPayload));
    }

    public Flux<Payload> requestChannel(Publisher<Payload> payloads) {
        this.clearThreadLocal();
        return Flux.from(payloads).switchOnFirst((firstSignal, flux) -> {
            Payload firstPayload = (Payload)firstSignal.get();
            if (firstPayload != null) {
                Span handle = this.consumerSpanBuilder(firstPayload.sliceMetadata(), FrameType.REQUEST_CHANNEL);
                if (handle == null) {
                    return super.requestChannel((Publisher)flux);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Created consumer span " + handle));
                }
                Payload newPayload = PayloadUtils.cleanTracingMetadata(firstPayload, new HashSet<String>(this.propagator.fields()));
                return ReactorSleuth.tracedFlux(this.tracer, handle, () -> super.requestChannel((Publisher)flux.skip(1L).startWith((Object[])new Payload[]{newPayload})));
            }
            return flux;
        });
    }

    private Span consumerSpanBuilder(ByteBuf headers, FrameType requestType) {
        Span.Builder consumerSpanBuilder = this.consumerSpanBuilder(headers);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Extracted result from headers " + consumerSpanBuilder));
        }
        ByteBuf extract = CompositeMetadataUtils.extract(headers, WellKnownMimeType.MESSAGE_RSOCKET_ROUTING.getString());
        String name = "handle";
        if (extract != null) {
            RoutingMetadata routingMetadata = new RoutingMetadata(extract);
            Iterator iterator = routingMetadata.iterator();
            name = requestType.name() + " " + (String)iterator.next();
        }
        return AssertingSpanBuilder.of((DocumentedSpan)SleuthRSocketSpan.RSOCKET_RESPONDER_SPAN, (Span.Builder)consumerSpanBuilder.kind(Span.Kind.CONSUMER)).name(name).start();
    }

    private Span.Builder consumerSpanBuilder(ByteBuf headers) {
        if (this.isZipkinPropagationEnabled) {
            ByteBuf extract = CompositeMetadataUtils.extract(headers, WellKnownMimeType.MESSAGE_RSOCKET_TRACING_ZIPKIN.getString());
            if (extract != null) {
                TracingMetadata tracingMetadata = TracingMetadataCodec.decode((ByteBuf)extract);
                Span.Builder builder = this.tracer.spanBuilder();
                String traceId = EncodingUtils.fromLong(tracingMetadata.traceId());
                long traceIdHigh = tracingMetadata.traceIdHigh();
                if (traceIdHigh != 0L) {
                    traceId = EncodingUtils.fromLong(traceIdHigh) + traceId;
                }
                TraceContext.Builder parentBuilder = this.tracer.traceContextBuilder().sampled(Boolean.valueOf(tracingMetadata.isDebug() || tracingMetadata.isSampled())).traceId(traceId).spanId(EncodingUtils.fromLong(tracingMetadata.spanId())).parentId(EncodingUtils.fromLong(tracingMetadata.parentId()));
                return builder.setParent(parentBuilder.build());
            }
            return this.propagator.extract((Object)headers, this.getter);
        }
        return this.propagator.extract((Object)headers, this.getter);
    }
}

