/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.zipkin2;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnNotWebApplication;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.sleuth.autoconfig.zipkin2.ZipkinSenderCondition;
import org.springframework.cloud.sleuth.autoconfig.zipkin2.ZipkinSenderProperties;
import org.springframework.cloud.sleuth.zipkin2.CachingZipkinUrlExtractor;
import org.springframework.cloud.sleuth.zipkin2.LoadBalancerClientZipkinLoadBalancer;
import org.springframework.cloud.sleuth.zipkin2.RestTemplateSender;
import org.springframework.cloud.sleuth.zipkin2.StaticInstanceZipkinLoadBalancer;
import org.springframework.cloud.sleuth.zipkin2.WebClientSender;
import org.springframework.cloud.sleuth.zipkin2.ZipkinLoadBalancer;
import org.springframework.cloud.sleuth.zipkin2.ZipkinProperties;
import org.springframework.cloud.sleuth.zipkin2.ZipkinRestTemplateCustomizer;
import org.springframework.cloud.sleuth.zipkin2.ZipkinRestTemplateProvider;
import org.springframework.cloud.sleuth.zipkin2.ZipkinRestTemplateWrapper;
import org.springframework.cloud.sleuth.zipkin2.ZipkinUrlExtractor;
import org.springframework.cloud.sleuth.zipkin2.ZipkinWebClientBuilderProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.reactive.function.client.WebClient;
import zipkin2.codec.BytesEncoder;
import zipkin2.reporter.Sender;

@Configuration(proxyBeanMethods=false)
@ConditionalOnMissingBean(name={"zipkinSender"})
@Conditional(value={ZipkinSenderCondition.class})
@EnableConfigurationProperties(value={ZipkinSenderProperties.class})
class ZipkinHttpSenderConfiguration {
    ZipkinHttpSenderConfiguration() {
    }

    static final class NonWebApplicationOrServletCondition
    extends AnyNestedCondition {
        private NonWebApplicationOrServletCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
        static class OnServlet {
            OnServlet() {
            }
        }

        @ConditionalOnNotWebApplication
        static class OnNonWeb {
            OnNonWeb() {
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={LoadBalancerClient.class})
    static class DiscoveryClientZipkinUrlExtractorConfiguration {
        DiscoveryClientZipkinUrlExtractorConfiguration() {
        }

        @Configuration(proxyBeanMethods=false)
        @ConditionalOnProperty(value={"spring.zipkin.discovery-client-enabled"}, havingValue="false")
        static class ZipkinClientNoOpConfiguration {
            ZipkinClientNoOpConfiguration() {
            }

            @Bean
            @ConditionalOnMissingBean
            ZipkinLoadBalancer staticInstanceLoadBalancer(ZipkinProperties zipkinProperties) {
                return new StaticInstanceZipkinLoadBalancer(zipkinProperties);
            }
        }

        @Configuration(proxyBeanMethods=false)
        @ConditionalOnProperty(value={"spring.zipkin.discovery-client-enabled"}, havingValue="true", matchIfMissing=true)
        static class ZipkinClientLoadBalancedConfiguration {
            @Autowired(required=false)
            LoadBalancerClient client;

            ZipkinClientLoadBalancedConfiguration() {
            }

            @Bean
            @ConditionalOnMissingBean
            ZipkinLoadBalancer loadBalancerClientZipkinLoadBalancer(ZipkinProperties zipkinProperties) {
                return new LoadBalancerClientZipkinLoadBalancer(this.client, zipkinProperties);
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingClass(value={"org.springframework.cloud.client.loadbalancer.LoadBalancerClient"})
    static class DefaultZipkinUrlExtractorConfiguration {
        @Autowired(required=false)
        LoadBalancerClient client;

        DefaultZipkinUrlExtractorConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        ZipkinLoadBalancer staticInstanceLoadBalancer(ZipkinProperties zipkinProperties) {
            return new StaticInstanceZipkinLoadBalancer(zipkinProperties);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    static class ZipkinReactiveConfiguration {
        ZipkinReactiveConfiguration() {
        }

        @Bean(value={"zipkinSender"})
        Sender webClientSender(ZipkinProperties zipkin, ZipkinWebClientBuilderProvider zipkinWebClientBuilderProvider) {
            WebClient.Builder webClientBuilder = zipkinWebClientBuilderProvider.zipkinWebClientBuilder();
            return new WebClientSender(webClientBuilder.build(), zipkin.getBaseUrl(), zipkin.getApiPath(), (BytesEncoder)zipkin.getEncoder());
        }

        @Bean
        @ConditionalOnMissingBean
        ZipkinWebClientBuilderProvider defaultZipkinWebClientProvider() {
            return WebClient::builder;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @Conditional(value={NonWebApplicationOrServletCondition.class})
    static class ZipkinServletConfiguration {
        ZipkinServletConfiguration() {
        }

        @Bean(value={"zipkinSender"})
        Sender restTemplateSender(ZipkinProperties zipkin, ZipkinRestTemplateCustomizer zipkinRestTemplateCustomizer, ZipkinRestTemplateProvider zipkinRestTemplateProvider) {
            RestTemplate restTemplate = zipkinRestTemplateProvider.zipkinRestTemplate();
            restTemplate = zipkinRestTemplateCustomizer.customizeTemplate(restTemplate);
            return new RestTemplateSender(restTemplate, zipkin.getBaseUrl(), zipkin.getApiPath(), (BytesEncoder)zipkin.getEncoder());
        }

        @Bean
        @ConditionalOnMissingBean
        ZipkinRestTemplateProvider zipkinRestTemplateProvider(ZipkinProperties zipkin, ZipkinUrlExtractor extractor) {
            return () -> new ZipkinRestTemplateWrapper(zipkin, extractor);
        }

        @Bean
        ZipkinUrlExtractor defaultZipkinUrlExtractor(ZipkinLoadBalancer zipkinLoadBalancer) {
            return new CachingZipkinUrlExtractor(zipkinLoadBalancer);
        }
    }
}

