/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.maven;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.apache.maven.toolchain.ToolchainManager;
import org.springframework.boot.maven.AbstractDependencyFilterMojo;
import org.springframework.boot.maven.CommandLineBuilder;
import org.springframework.boot.maven.JavaCompilerPluginConfiguration;
import org.springframework.boot.maven.JavaProcessExecutor;
import org.springframework.boot.maven.RunArguments;

public abstract class AbstractAotMojo
extends AbstractDependencyFilterMojo {
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Component
    private ToolchainManager toolchainManager;
    @Parameter(property="spring-boot.aot.skip", defaultValue="false")
    private boolean skip;
    @Parameter
    private Map<String, String> systemPropertyVariables;
    @Parameter(property="spring-boot.aot.jvmArguments")
    private String jvmArguments;
    @Parameter(property="spring-boot.aot.compilerArguments")
    private String compilerArguments;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().debug((CharSequence)"Skipping AOT execution as per configuration");
            return;
        }
        try {
            this.executeAot();
        }
        catch (Exception ex) {
            throw new MojoExecutionException(ex.getMessage(), ex);
        }
    }

    protected abstract void executeAot() throws Exception;

    protected void generateAotAssets(URL[] classPath, String processorClassName, String ... arguments) throws Exception {
        List<String> command = CommandLineBuilder.forMainClass(processorClassName).withSystemProperties(this.systemPropertyVariables).withJvmArguments(new RunArguments(this.jvmArguments).asArray()).withClasspath(classPath).withArguments(arguments).build();
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Generating AOT assets using command: " + command));
        }
        JavaProcessExecutor processExecutor = new JavaProcessExecutor(this.session, this.toolchainManager);
        processExecutor.run(this.project.getBasedir(), command, Collections.emptyMap());
    }

    protected final void compileSourceFiles(URL[] classPath, File sourcesDirectory, File outputDirectory) throws Exception {
        List<Path> sourceFiles = Files.walk(sourcesDirectory.toPath(), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).toList();
        if (sourceFiles.isEmpty()) {
            return;
        }
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        try (StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);){
            JavaCompilerPluginConfiguration compilerConfiguration = new JavaCompilerPluginConfiguration(this.project);
            ArrayList<String> options = new ArrayList<String>();
            options.add("-cp");
            options.add(CommandLineBuilder.ClasspathBuilder.build(Arrays.asList(classPath)));
            options.add("-d");
            options.add(outputDirectory.toPath().toAbsolutePath().toString());
            options.add("--source");
            options.add(compilerConfiguration.getSourceMajorVersion());
            options.add("--target");
            options.add(compilerConfiguration.getTargetMajorVersion());
            String releaseVersion = compilerConfiguration.getReleaseVersion();
            if (releaseVersion != null) {
                options.add("--release");
                options.add(releaseVersion);
            }
            options.addAll(new RunArguments(this.compilerArguments).getArgs());
            Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromPaths((Collection<? extends Path>)sourceFiles);
            Errors errors = new Errors();
            JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, errors, options, null, compilationUnits);
            boolean result = task.call();
            if (!result || errors.hasReportedErrors()) {
                throw new IllegalStateException("Unable to compile generated source" + errors);
            }
        }
    }

    protected final URL[] getClassPath(File[] directories, ArtifactsFilter ... artifactFilters) throws MojoExecutionException {
        ArrayList<URL> urls = new ArrayList<URL>();
        Arrays.stream(directories).map(this::toURL).forEach(urls::add);
        urls.addAll(this.getDependencyURLs(artifactFilters));
        return (URL[])urls.toArray(URL[]::new);
    }

    protected final void copyAll(Path from, Path to) throws IOException {
        List<Path> files = Files.exists(from, new LinkOption[0]) ? Files.walk(from, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).toList() : Collections.emptyList();
        for (Path file : files) {
            String relativeFileName = file.subpath(from.getNameCount(), file.getNameCount()).toString();
            this.getLog().debug((CharSequence)("Copying '" + relativeFileName + "' to " + to));
            Path target = to.resolve(relativeFileName);
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            Files.copy(file, target, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    protected static class Errors
    implements DiagnosticListener<JavaFileObject> {
        private final StringBuilder message = new StringBuilder();

        protected Errors() {
        }

        @Override
        public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
            if (diagnostic.getKind() == Diagnostic.Kind.ERROR) {
                this.message.append("\n");
                this.message.append(diagnostic.getMessage(Locale.getDefault()));
                if (diagnostic.getSource() != null) {
                    this.message.append(" ");
                    this.message.append(diagnostic.getSource().getName());
                    this.message.append(" ");
                    this.message.append(diagnostic.getLineNumber()).append(":").append(diagnostic.getColumnNumber());
                }
            }
        }

        boolean hasReportedErrors() {
            return this.message.length() > 0;
        }

        public String toString() {
            return this.message.toString();
        }
    }
}

