/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker.transport;

import java.net.URISyntaxException;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.HttpHost;
import org.springframework.boot.buildpack.platform.docker.configuration.DockerHost;
import org.springframework.boot.buildpack.platform.docker.configuration.ResolvedDockerHost;
import org.springframework.boot.buildpack.platform.docker.ssl.SslContextFactory;
import org.springframework.boot.buildpack.platform.docker.transport.HttpClientTransport;
import org.springframework.util.Assert;

final class RemoteHttpClientTransport
extends HttpClientTransport {
    private RemoteHttpClientTransport(HttpClient client, HttpHost host) {
        super(client, host);
    }

    static RemoteHttpClientTransport createIfPossible(ResolvedDockerHost dockerHost) {
        return RemoteHttpClientTransport.createIfPossible(dockerHost, new SslContextFactory());
    }

    static RemoteHttpClientTransport createIfPossible(ResolvedDockerHost dockerHost, SslContextFactory sslContextFactory) {
        if (!dockerHost.isRemote()) {
            return null;
        }
        try {
            return RemoteHttpClientTransport.create(dockerHost, sslContextFactory, HttpHost.create((String)dockerHost.getAddress()));
        }
        catch (URISyntaxException ex) {
            return null;
        }
    }

    private static RemoteHttpClientTransport create(DockerHost host, SslContextFactory sslContextFactory, HttpHost tcpHost) {
        HttpClientBuilder builder = HttpClients.custom();
        if (host.isSecure()) {
            PoolingHttpClientConnectionManager connectionManager = PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory(RemoteHttpClientTransport.getSecureConnectionSocketFactory(host, sslContextFactory)).build();
            builder.setConnectionManager((HttpClientConnectionManager)connectionManager);
        }
        String scheme = host.isSecure() ? "https" : "http";
        HttpHost httpHost = new HttpHost(scheme, tcpHost.getHostName(), tcpHost.getPort());
        return new RemoteHttpClientTransport((HttpClient)builder.build(), httpHost);
    }

    private static LayeredConnectionSocketFactory getSecureConnectionSocketFactory(DockerHost host, SslContextFactory sslContextFactory) {
        String directory = host.getCertificatePath();
        Assert.hasText((String)directory, () -> "Docker host TLS verification requires trust material location to be specified with certificate path");
        SSLContext sslContext = sslContextFactory.forDirectory(directory);
        return new SSLConnectionSocketFactory(sslContext);
    }
}

