/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.web;

import org.jspecify.annotations.Nullable;
import org.springframework.boot.web.server.context.WebServerApplicationContext;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public final class WebServerNamespace {
    private static final String WEB_SERVER_CONTEXT_CLASS = "org.springframework.boot.web.server.context.WebServerApplicationContext";
    public static final WebServerNamespace SERVER = new WebServerNamespace("server");
    public static final WebServerNamespace MANAGEMENT = new WebServerNamespace("management");
    private final String value;

    private WebServerNamespace(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        WebServerNamespace other = (WebServerNamespace)obj;
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return this.value;
    }

    public static WebServerNamespace from(@Nullable ApplicationContext context) {
        if (!ClassUtils.isPresent((String)WEB_SERVER_CONTEXT_CLASS, null)) {
            return SERVER;
        }
        return WebServerNamespace.from(WebServerApplicationContext.getServerNamespace((ApplicationContext)context));
    }

    public static WebServerNamespace from(@Nullable String value) {
        if (StringUtils.hasText((String)value)) {
            return new WebServerNamespace(value);
        }
        return SERVER;
    }
}

