/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.web.server;

import java.lang.reflect.Modifier;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.ApplicationContextFactory;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.support.SystemEnvironmentPropertySourceEnvironmentPostProcessor;
import org.springframework.boot.web.server.WebServerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigRegistry;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;

public final class ManagementContextFactory {
    private final WebApplicationType webApplicationType;
    private final Class<? extends WebServerFactory> webServerFactoryClass;
    private final Class<?>[] autoConfigurationClasses;

    public ManagementContextFactory(WebApplicationType webApplicationType, Class<? extends WebServerFactory> webServerFactoryClass, Class<?> ... autoConfigurationClasses) {
        this.webApplicationType = webApplicationType;
        this.webServerFactoryClass = webServerFactoryClass;
        this.autoConfigurationClasses = autoConfigurationClasses;
    }

    public ConfigurableApplicationContext createManagementContext(ApplicationContext parentContext) {
        ConfigurableApplicationContext managementContext;
        Environment parentEnvironment = parentContext.getEnvironment();
        ConfigurableEnvironment childEnvironment = ApplicationContextFactory.DEFAULT.createEnvironment(this.webApplicationType);
        Assert.state((childEnvironment != null ? 1 : 0) != 0, (String)"'childEnvironment' must not be null");
        if (parentEnvironment instanceof ConfigurableEnvironment) {
            ConfigurableEnvironment configurableParentEnvironment = (ConfigurableEnvironment)parentEnvironment;
            this.postProcessChildEnvironment(childEnvironment, configurableParentEnvironment);
        }
        Assert.state(((managementContext = ApplicationContextFactory.DEFAULT.create(this.webApplicationType)) != null ? 1 : 0) != 0, (String)"'managementContext' must not be null");
        managementContext.setEnvironment(childEnvironment);
        managementContext.setParent(parentContext);
        return managementContext;
    }

    private void postProcessChildEnvironment(ConfigurableEnvironment childEnvironment, ConfigurableEnvironment parentEnvironment) {
        childEnvironment.setConversionService(parentEnvironment.getConversionService());
        SystemEnvironmentPropertySourceEnvironmentPostProcessor.postProcessEnvironment((ConfigurableEnvironment)childEnvironment, (ConfigurableEnvironment)parentEnvironment);
    }

    public void registerWebServerFactoryBeans(ApplicationContext parentContext, ConfigurableApplicationContext managementContext, AnnotationConfigRegistry registry) {
        if (this.autoConfigurationClasses != null && this.autoConfigurationClasses.length > 0) {
            registry.register((Class[])this.autoConfigurationClasses);
        }
        this.registerWebServerFactoryFromParent(parentContext, managementContext);
    }

    private void registerWebServerFactoryFromParent(ApplicationContext parentContext, ConfigurableApplicationContext managementContext) {
        try {
            ConfigurableListableBeanFactory configurableListableBeanFactory = managementContext.getBeanFactory();
            if (configurableListableBeanFactory instanceof BeanDefinitionRegistry) {
                BeanDefinitionRegistry registry = (BeanDefinitionRegistry)configurableListableBeanFactory;
                registry.registerBeanDefinition("ManagementContextWebServerFactory", (BeanDefinition)new RootBeanDefinition(this.determineWebServerFactoryClass(parentContext)));
            }
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
    }

    private Class<?> determineWebServerFactoryClass(ApplicationContext parent) throws NoSuchBeanDefinitionException {
        Class factoryClass = ((WebServerFactory)parent.getBean(this.webServerFactoryClass)).getClass();
        if (this.cannotBeInstantiated(factoryClass)) {
            throw new FatalBeanException("ManagementContextWebServerFactory implementation " + factoryClass.getName() + " cannot be instantiated. To allow a separate management port to be used, a top-level class or static inner class should be used instead");
        }
        return factoryClass;
    }

    private boolean cannotBeInstantiated(Class<?> factoryClass) {
        return factoryClass.isLocalClass() || factoryClass.isMemberClass() && !Modifier.isStatic(factoryClass.getModifiers()) || factoryClass.isAnonymousClass();
    }
}

