/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.endpoint;

import java.util.List;
import java.util.function.Function;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.endpoint.EndpointIdTimeToLivePropertyFunction;
import org.springframework.boot.actuate.autoconfigure.endpoint.PropertiesEndpointAccessResolver;
import org.springframework.boot.actuate.endpoint.EndpointAccessResolver;
import org.springframework.boot.actuate.endpoint.annotation.EndpointConverter;
import org.springframework.boot.actuate.endpoint.invoke.ParameterValueMapper;
import org.springframework.boot.actuate.endpoint.invoke.convert.ConversionServiceParameterValueMapper;
import org.springframework.boot.actuate.endpoint.invoker.cache.CachingOperationInvokerAdvisor;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.convert.ApplicationConversionService;
import org.springframework.context.annotation.Bean;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;

@AutoConfiguration
public final class EndpointAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    ParameterValueMapper endpointOperationParameterMapper(@EndpointConverter ObjectProvider<Converter<?, ?>> converters, @EndpointConverter ObjectProvider<GenericConverter> genericConverters) {
        ConversionService conversionService = this.createConversionService(converters.orderedStream().toList(), genericConverters.orderedStream().toList());
        return new ConversionServiceParameterValueMapper(conversionService);
    }

    private ConversionService createConversionService(List<Converter<?, ?>> converters, List<GenericConverter> genericConverters) {
        if (genericConverters.isEmpty() && converters.isEmpty()) {
            return ApplicationConversionService.getSharedInstance();
        }
        ApplicationConversionService conversionService = new ApplicationConversionService();
        converters.forEach(arg_0 -> ((ApplicationConversionService)conversionService).addConverter(arg_0));
        genericConverters.forEach(arg_0 -> ((ApplicationConversionService)conversionService).addConverter(arg_0));
        return conversionService;
    }

    @Bean
    @ConditionalOnMissingBean
    CachingOperationInvokerAdvisor endpointCachingOperationInvokerAdvisor(Environment environment) {
        return new CachingOperationInvokerAdvisor((Function)new EndpointIdTimeToLivePropertyFunction(environment));
    }

    @Bean
    @ConditionalOnMissingBean(value={EndpointAccessResolver.class})
    PropertiesEndpointAccessResolver propertiesEndpointAccessResolver(Environment environment) {
        return new PropertiesEndpointAccessResolver((PropertyResolver)environment);
    }
}

