/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.logging.Log4j2Metrics;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Configuration
@AutoConfigureAfter(value={MetricsAutoConfiguration.class})
@ConditionalOnClass(value={Log4j2Metrics.class, LoggerContext.class, LogManager.class})
@ConditionalOnBean(value={MeterRegistry.class})
@Conditional(value={Log4JCoreLoggerContextCondition.class})
public class Log4J2MetricsAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public Log4j2Metrics log4j2Metrics() {
        return new Log4j2Metrics(Collections.emptyList(), (LoggerContext)LogManager.getContext((boolean)false));
    }

    static class Log4JCoreLoggerContextCondition
    extends SpringBootCondition {
        Log4JCoreLoggerContextCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            org.apache.logging.log4j.spi.LoggerContext loggerContext = LogManager.getContext((boolean)false);
            if (loggerContext instanceof LoggerContext) {
                return ConditionOutcome.match((String)"LoggerContext was an instance of org.apache.logging.log4j.spi.LoggerContext");
            }
            return ConditionOutcome.noMatch((String)"Logger context was not an instance of org.apache.logging.log4j.spi.LoggerContext");
        }
    }
}

